/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.aggregation;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.max.Max;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentile;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentiles;

class AggregationToJsonProcessor
implements Releasable {
    private final String timeField;
    private final boolean includeDocCount;
    private final XContentBuilder jsonBuilder;
    private final Map<String, Object> keyValuePairs;
    private long keyValueWrittenCount;

    AggregationToJsonProcessor(String timeField, boolean includeDocCount, OutputStream outputStream) throws IOException {
        this.timeField = Objects.requireNonNull(timeField);
        this.includeDocCount = includeDocCount;
        this.jsonBuilder = new XContentBuilder((XContent)JsonXContent.jsonXContent, outputStream);
        this.keyValuePairs = new LinkedHashMap<String, Object>();
        this.keyValueWrittenCount = 0L;
    }

    public void process(Histogram.Bucket bucket) throws IOException {
        Aggregation timeAgg;
        if (bucket.getDocCount() == 0L) {
            return;
        }
        Aggregations aggs = bucket.getAggregations();
        Aggregation aggregation = timeAgg = aggs == null ? null : aggs.get(this.timeField);
        if (!(timeAgg instanceof Max)) {
            throw new IllegalArgumentException("Missing max aggregation for time_field [" + this.timeField + "]");
        }
        long timestamp = (long)((Max)timeAgg).value();
        this.keyValuePairs.put(this.timeField, timestamp);
        ArrayList<Aggregation> subAggs = new ArrayList<Aggregation>(aggs.asList());
        subAggs.remove(timeAgg);
        this.processNestedAggs(bucket.getDocCount(), subAggs);
    }

    private void processNestedAggs(long docCount, List<Aggregation> aggs) throws IOException {
        if (aggs.isEmpty()) {
            this.writeJsonObject(docCount);
            return;
        }
        if (aggs.get(0) instanceof Terms) {
            if (aggs.size() > 1) {
                throw new IllegalArgumentException("Multiple non-leaf nested aggregations are not supported");
            }
            this.processTerms((Terms)aggs.get(0));
        } else {
            ArrayList<String> addedKeys = new ArrayList<String>();
            for (Aggregation nestedAgg : aggs) {
                if (nestedAgg instanceof NumericMetricsAggregation.SingleValue) {
                    addedKeys.add(this.processSingleValue((NumericMetricsAggregation.SingleValue)nestedAgg));
                    continue;
                }
                if (nestedAgg instanceof Percentiles) {
                    addedKeys.add(this.processPercentiles((Percentiles)nestedAgg));
                    continue;
                }
                throw new IllegalArgumentException("Unsupported aggregation type [" + nestedAgg.getName() + "]");
            }
            this.writeJsonObject(docCount);
            addedKeys.forEach(k -> this.keyValuePairs.remove(k));
        }
    }

    private void processTerms(Terms termsAgg) throws IOException {
        for (Terms.Bucket bucket : termsAgg.getBuckets()) {
            this.keyValuePairs.put(termsAgg.getName(), bucket.getKey());
            this.processNestedAggs(bucket.getDocCount(), AggregationToJsonProcessor.asList(bucket.getAggregations()));
            this.keyValuePairs.remove(termsAgg.getName());
        }
    }

    private String processSingleValue(NumericMetricsAggregation.SingleValue singleValue) throws IOException {
        this.keyValuePairs.put(singleValue.getName(), singleValue.value());
        return singleValue.getName();
    }

    private String processPercentiles(Percentiles percentiles) throws IOException {
        Iterator percentileIterator = percentiles.iterator();
        this.keyValuePairs.put(percentiles.getName(), ((Percentile)percentileIterator.next()).getValue());
        if (percentileIterator.hasNext()) {
            throw new IllegalArgumentException("Multi-percentile aggregation [" + percentiles.getName() + "] is not supported");
        }
        return percentiles.getName();
    }

    private void writeJsonObject(long docCount) throws IOException {
        if (docCount > 0L) {
            this.jsonBuilder.startObject();
            for (Map.Entry<String, Object> keyValue : this.keyValuePairs.entrySet()) {
                this.jsonBuilder.field(keyValue.getKey(), keyValue.getValue());
                ++this.keyValueWrittenCount;
            }
            if (this.includeDocCount) {
                this.jsonBuilder.field("doc_count", docCount);
                ++this.keyValueWrittenCount;
            }
            this.jsonBuilder.endObject();
        }
    }

    public void close() {
        this.jsonBuilder.close();
    }

    public long getKeyValueCount() {
        return this.keyValueWrittenCount;
    }

    private static List<Aggregation> asList(@Nullable Aggregations aggs) {
        return aggs == null ? Collections.emptyList() : aggs.asList();
    }
}

