/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed;

import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.ml.job.config.AnalysisConfig;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.messages.Messages;

public final class DatafeedJobValidator {
    private DatafeedJobValidator() {
    }

    public static void validate(DatafeedConfig datafeedConfig, Job job) {
        AnalysisConfig analysisConfig = job.getAnalysisConfig();
        if (analysisConfig.getLatency() != null && analysisConfig.getLatency().seconds() > 0L) {
            throw new IllegalArgumentException(Messages.getMessage("A job configured with datafeed cannot support latency"));
        }
        if (datafeedConfig.hasAggregations()) {
            DatafeedJobValidator.checkSummaryCountFieldNameIsSet(analysisConfig);
            DatafeedJobValidator.checkValidHistogramInterval(datafeedConfig, analysisConfig);
        }
    }

    private static void checkSummaryCountFieldNameIsSet(AnalysisConfig analysisConfig) {
        if (Strings.isNullOrEmpty((String)analysisConfig.getSummaryCountFieldName())) {
            throw new IllegalArgumentException(Messages.getMessage("A job configured with a datafeed with aggregations must set summary_count_field_name; use doc_count or suitable alternative"));
        }
    }

    private static void checkValidHistogramInterval(DatafeedConfig datafeedConfig, AnalysisConfig analysisConfig) {
        long bucketSpanMillis;
        long histogramIntervalMillis = datafeedConfig.getHistogramIntervalMillis();
        if (histogramIntervalMillis > (bucketSpanMillis = analysisConfig.getBucketSpan().millis())) {
            throw new IllegalArgumentException(Messages.getMessage("Aggregation interval [{0}] must be less than or equal to the bucket_span [{1}]", TimeValue.timeValueMillis((long)histogramIntervalMillis).getStringRep(), TimeValue.timeValueMillis((long)bucketSpanMillis).getStringRep()));
        }
    }
}

