/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.MlMetadata;
import org.elasticsearch.xpack.ml.action.PutDatafeedAction;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.ml.datafeed.DatafeedUpdate;
import org.elasticsearch.xpack.persistent.PersistentTasksCustomMetaData;

public class UpdateDatafeedAction
extends Action<Request, PutDatafeedAction.Response, RequestBuilder> {
    public static final UpdateDatafeedAction INSTANCE = new UpdateDatafeedAction();
    public static final String NAME = "cluster:admin/xpack/ml/datafeeds/update";

    private UpdateDatafeedAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public PutDatafeedAction.Response newResponse() {
        return new PutDatafeedAction.Response();
    }

    public static class TransportAction
    extends TransportMasterNodeAction<Request, PutDatafeedAction.Response> {
        @Inject
        public TransportAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(settings, UpdateDatafeedAction.NAME, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, Request::new);
        }

        protected String executor() {
            return "same";
        }

        protected PutDatafeedAction.Response newResponse() {
            return new PutDatafeedAction.Response();
        }

        protected void masterOperation(final Request request, ClusterState state, ActionListener<PutDatafeedAction.Response> listener) throws Exception {
            this.clusterService.submitStateUpdateTask("update-datafeed-" + request.getUpdate().getId(), (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<PutDatafeedAction.Response>((AckedRequest)request, listener){
                private volatile DatafeedConfig updatedDatafeed;

                protected PutDatafeedAction.Response newResponse(boolean acknowledged) {
                    if (acknowledged) {
                        logger.info("Updated datafeed [{}]", (Object)request.getUpdate().getId());
                    }
                    return new PutDatafeedAction.Response(acknowledged, this.updatedDatafeed);
                }

                public ClusterState execute(ClusterState currentState) throws Exception {
                    DatafeedUpdate update = request.getUpdate();
                    MlMetadata currentMetadata = (MlMetadata)currentState.getMetaData().custom("ml");
                    PersistentTasksCustomMetaData persistentTasks = (PersistentTasksCustomMetaData)currentState.getMetaData().custom("persistent_tasks");
                    MlMetadata newMetadata = new MlMetadata.Builder(currentMetadata).updateDatafeed(update, persistentTasks).build();
                    this.updatedDatafeed = newMetadata.getDatafeed(update.getId());
                    return ClusterState.builder((ClusterState)currentState).metaData(MetaData.builder((MetaData)currentState.getMetaData()).putCustom("ml", (MetaData.Custom)newMetadata).build()).build();
                }
            });
        }

        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }
    }

    public static class RequestBuilder
    extends MasterNodeOperationRequestBuilder<Request, PutDatafeedAction.Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client, UpdateDatafeedAction action) {
            super(client, (Action)action, (MasterNodeRequest)new Request());
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContent {
        private DatafeedUpdate update;

        public static Request parseRequest(String datafeedId, XContentParser parser) {
            DatafeedUpdate.Builder update = (DatafeedUpdate.Builder)DatafeedUpdate.PARSER.apply(parser, null);
            update.setId(datafeedId);
            return new Request(update.build());
        }

        public Request(DatafeedUpdate update) {
            this.update = update;
        }

        Request() {
        }

        public DatafeedUpdate getUpdate() {
            return this.update;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.update = new DatafeedUpdate(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.update.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.update.toXContent(builder, params);
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.update, request.update);
        }

        public int hashCode() {
            return Objects.hash(this.update);
        }
    }
}

