/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.MlMetadata;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.config.JobTaskStatus;
import org.elasticsearch.xpack.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.persistent.AllocatedPersistentTask;
import org.elasticsearch.xpack.persistent.PersistentTaskParams;
import org.elasticsearch.xpack.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.xpack.persistent.PersistentTasksExecutor;
import org.elasticsearch.xpack.persistent.PersistentTasksService;

public class OpenJobAction
extends Action<Request, Response, RequestBuilder> {
    public static final OpenJobAction INSTANCE = new OpenJobAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/open";
    public static final String TASK_NAME = "xpack/ml/job";

    private OpenJobAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    static void validate(String jobId, MlMetadata mlMetadata) {
        Job job = mlMetadata.getJobs().get(jobId);
        if (job == null) {
            throw ExceptionsHelper.missingJobException(jobId);
        }
        if (job.isDeleted()) {
            throw ExceptionsHelper.conflictStatusException("Cannot open job [" + jobId + "] because it has been marked as deleted", new Object[0]);
        }
    }

    static PersistentTasksCustomMetaData.Assignment selectLeastLoadedMlNode(String jobId, ClusterState clusterState, int maxConcurrentJobAllocations, long maxNumberOfOpenJobs, Logger logger) {
        List<String> unavailableIndices = OpenJobAction.verifyIndicesPrimaryShardsAreActive(jobId, clusterState);
        if (unavailableIndices.size() != 0) {
            String reason = "Not opening job [" + jobId + "], because not all primary shards are active for the following indices [" + String.join((CharSequence)",", unavailableIndices) + "]";
            logger.debug(reason);
            return new PersistentTasksCustomMetaData.Assignment(null, reason);
        }
        long maxAvailable = Long.MIN_VALUE;
        LinkedList<String> reasons = new LinkedList<String>();
        DiscoveryNode minLoadedNode = null;
        PersistentTasksCustomMetaData persistentTasks = (PersistentTasksCustomMetaData)clusterState.getMetaData().custom("persistent_tasks");
        for (DiscoveryNode node : clusterState.getNodes()) {
            int numberOfAllocatingJobs;
            long numberOfAssignedJobs;
            Map nodeAttributes = node.getAttributes();
            String enabled = (String)nodeAttributes.get("ml.enabled");
            if (!Boolean.valueOf(enabled).booleanValue()) {
                String reason = "Not opening job [" + jobId + "] on node [" + node + "], because this node isn't a ml node.";
                logger.trace(reason);
                reasons.add(reason);
                continue;
            }
            if (persistentTasks != null) {
                numberOfAssignedJobs = persistentTasks.getNumberOfTasksOnNode(node.getId(), TASK_NAME);
                numberOfAllocatingJobs = persistentTasks.findTasks(TASK_NAME, task -> {
                    if (!node.getId().equals(task.getExecutorNode())) {
                        return false;
                    }
                    JobTaskStatus jobTaskState = (JobTaskStatus)task.getStatus();
                    return jobTaskState == null || jobTaskState.isStatusStale((PersistentTasksCustomMetaData.PersistentTask<?>)task);
                }).size();
            } else {
                numberOfAssignedJobs = 0L;
                numberOfAllocatingJobs = 0;
            }
            if (numberOfAllocatingJobs >= maxConcurrentJobAllocations) {
                String reason = "Not opening job [" + jobId + "] on node [" + node + "], because node exceeds [" + numberOfAllocatingJobs + "] the maximum number of jobs [" + maxConcurrentJobAllocations + "] in opening state";
                logger.trace(reason);
                reasons.add(reason);
                continue;
            }
            long available = maxNumberOfOpenJobs - numberOfAssignedJobs;
            if (available == 0L) {
                String reason = "Not opening job [" + jobId + "] on node [" + node + "], because this node is full. Number of opened jobs [" + numberOfAssignedJobs + "], " + AutodetectProcessManager.MAX_RUNNING_JOBS_PER_NODE.getKey() + " [" + maxNumberOfOpenJobs + "]";
                logger.trace(reason);
                reasons.add(reason);
                continue;
            }
            if (maxAvailable >= available) continue;
            maxAvailable = available;
            minLoadedNode = node;
        }
        if (minLoadedNode != null) {
            logger.debug("selected node [{}] for job [{}]", minLoadedNode, (Object)jobId);
            return new PersistentTasksCustomMetaData.Assignment(minLoadedNode.getId(), "");
        }
        String explanation = String.join((CharSequence)"|", reasons);
        logger.debug("no node selected for job [{}], reasons [{}]", (Object)jobId, (Object)explanation);
        return new PersistentTasksCustomMetaData.Assignment(null, explanation);
    }

    static String[] indicesOfInterest(ClusterState clusterState, String job) {
        String jobResultIndex = AnomalyDetectorsIndex.getPhysicalIndexFromState(clusterState, job);
        return new String[]{AnomalyDetectorsIndex.jobStateIndexName(), jobResultIndex, ".ml-meta"};
    }

    static List<String> verifyIndicesPrimaryShardsAreActive(String jobId, ClusterState clusterState) {
        String[] indices = OpenJobAction.indicesOfInterest(clusterState, jobId);
        ArrayList<String> unavailableIndices = new ArrayList<String>(indices.length);
        for (String index : indices) {
            IndexRoutingTable routingTable;
            if (!clusterState.metaData().hasIndex(index) || (routingTable = clusterState.getRoutingTable().index(index)) != null && routingTable.allPrimaryShardsActive()) continue;
            unavailableIndices.add(index);
        }
        return unavailableIndices;
    }

    public static class OpenJobPersistentTasksExecutor
    extends PersistentTasksExecutor<JobParams> {
        private final AutodetectProcessManager autodetectProcessManager;
        private final int maxNumberOfOpenJobs;
        private volatile int maxConcurrentJobAllocations;

        public OpenJobPersistentTasksExecutor(Settings settings, ClusterService clusterService, AutodetectProcessManager autodetectProcessManager) {
            super(settings, OpenJobAction.TASK_NAME, "ml_utility");
            this.autodetectProcessManager = autodetectProcessManager;
            this.maxNumberOfOpenJobs = (Integer)AutodetectProcessManager.MAX_RUNNING_JOBS_PER_NODE.get(settings);
            this.maxConcurrentJobAllocations = (Integer)MachineLearning.CONCURRENT_JOB_ALLOCATIONS.get(settings);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.CONCURRENT_JOB_ALLOCATIONS, this::setMaxConcurrentJobAllocations);
        }

        @Override
        public PersistentTasksCustomMetaData.Assignment getAssignment(JobParams params, ClusterState clusterState) {
            return OpenJobAction.selectLeastLoadedMlNode(params.getJobId(), clusterState, this.maxConcurrentJobAllocations, this.maxNumberOfOpenJobs, this.logger);
        }

        @Override
        public void validate(JobParams params, ClusterState clusterState) {
            MlMetadata mlMetadata = (MlMetadata)clusterState.metaData().custom("ml");
            OpenJobAction.validate(params.getJobId(), mlMetadata);
            PersistentTasksCustomMetaData.Assignment assignment = OpenJobAction.selectLeastLoadedMlNode(params.getJobId(), clusterState, this.maxConcurrentJobAllocations, this.maxNumberOfOpenJobs, this.logger);
            if (assignment.getExecutorNode() == null) {
                String msg = "Could not open job because no suitable nodes were found, allocation explanation [" + assignment.getExplanation() + "]";
                this.logger.warn("[{}] {}", (Object)params.getJobId(), (Object)msg);
                throw new ElasticsearchStatusException(msg, RestStatus.TOO_MANY_REQUESTS, new Object[0]);
            }
        }

        @Override
        protected void nodeOperation(AllocatedPersistentTask task, JobParams params) {
            JobTask jobTask = (JobTask)task;
            jobTask.autodetectProcessManager = this.autodetectProcessManager;
            this.autodetectProcessManager.openJob(jobTask, params.isIgnoreDowntime(), e2 -> {
                if (e2 == null) {
                    task.markAsCompleted();
                } else {
                    task.markAsFailed((Exception)e2);
                }
            });
        }

        @Override
        protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetaData.PersistentTask<JobParams> persistentTask) {
            return new JobTask(persistentTask.getParams().getJobId(), id, type, action, parentTaskId);
        }

        void setMaxConcurrentJobAllocations(int maxConcurrentJobAllocations) {
            this.logger.info("Changing [{}] from [{}] to [{}]", (Object)MachineLearning.CONCURRENT_JOB_ALLOCATIONS.getKey(), (Object)this.maxConcurrentJobAllocations, (Object)maxConcurrentJobAllocations);
            this.maxConcurrentJobAllocations = maxConcurrentJobAllocations;
        }
    }

    public static class TransportAction
    extends TransportMasterNodeAction<Request, Response> {
        private final XPackLicenseState licenseState;
        private final PersistentTasksService persistentTasksService;

        @Inject
        public TransportAction(Settings settings, TransportService transportService, ThreadPool threadPool, XPackLicenseState licenseState, ClusterService clusterService, PersistentTasksService persistentTasksService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
            super(settings, OpenJobAction.NAME, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, Request::new);
            this.licenseState = licenseState;
            this.persistentTasksService = persistentTasksService;
        }

        protected String executor() {
            return "same";
        }

        protected Response newResponse() {
            return new Response();
        }

        protected void masterOperation(Request request, ClusterState state, final ActionListener<Response> listener) throws Exception {
            final JobParams jobParams = request.getJobParams();
            if (this.licenseState.isMachineLearningAllowed()) {
                ActionListener<PersistentTasksCustomMetaData.PersistentTask<JobParams>> finalListener = new ActionListener<PersistentTasksCustomMetaData.PersistentTask<JobParams>>(){

                    public void onResponse(PersistentTasksCustomMetaData.PersistentTask<JobParams> task) {
                        this.waitForJobStarted(task.getId(), jobParams, (ActionListener<Response>)listener);
                    }

                    public void onFailure(Exception e) {
                        if (e instanceof ResourceAlreadyExistsException) {
                            e = new ElasticsearchStatusException("Cannot open job [" + jobParams.getJobId() + "] because it has already been opened", RestStatus.CONFLICT, (Throwable)e, new Object[0]);
                        }
                        listener.onFailure(e);
                    }
                };
                this.persistentTasksService.startPersistentTask(MlMetadata.jobTaskId(jobParams.jobId), OpenJobAction.TASK_NAME, jobParams, finalListener);
            } else {
                listener.onFailure((Exception)((Object)LicenseUtils.newComplianceException("ml")));
            }
        }

        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        }

        void waitForJobStarted(String taskId, final JobParams jobParams, final ActionListener<Response> listener) {
            final JobPredicate predicate = new JobPredicate();
            this.persistentTasksService.waitForPersistentTaskStatus(taskId, predicate, jobParams.timeout, new PersistentTasksService.WaitForPersistentTaskStatusListener<JobParams>(){

                public void onResponse(PersistentTasksCustomMetaData.PersistentTask<JobParams> persistentTask) {
                    listener.onResponse((Object)new Response(predicate.opened));
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    listener.onFailure((Exception)new ElasticsearchException("Opening job [" + jobParams.getJobId() + "] timed out after [" + timeout + "]", new Object[0]));
                }
            });
        }

        private class JobPredicate
        implements Predicate<PersistentTasksCustomMetaData.PersistentTask<?>> {
            private volatile boolean opened;

            private JobPredicate() {
            }

            @Override
            public boolean test(PersistentTasksCustomMetaData.PersistentTask<?> persistentTask) {
                if (persistentTask == null) {
                    return false;
                }
                JobTaskStatus jobState = (JobTaskStatus)persistentTask.getStatus();
                if (jobState == null) {
                    return false;
                }
                switch (jobState.getState()) {
                    case OPENED: {
                        this.opened = true;
                        return true;
                    }
                    case FAILED: {
                        return true;
                    }
                }
                throw new IllegalStateException("Unexpected job state [" + (Object)((Object)jobState.getState()) + "]");
            }
        }
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client, OpenJobAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }

    public static class JobTask
    extends AllocatedPersistentTask {
        private final String jobId;
        private volatile AutodetectProcessManager autodetectProcessManager;

        JobTask(String jobId, long id, String type, String action, TaskId parentTask) {
            super(id, type, action, "job-" + jobId, parentTask);
            this.jobId = jobId;
        }

        public String getJobId() {
            return this.jobId;
        }

        protected void onCancelled() {
            String reason = this.getReasonCancelled();
            this.closeJob(reason);
        }

        void closeJob(String reason) {
            this.autodetectProcessManager.closeJob(this, false, reason);
        }

        static boolean match(Task task, String expectedJobId) {
            String expectedDescription = "job-" + expectedJobId;
            return task instanceof JobTask && expectedDescription.equals(task.getDescription());
        }
    }

    public static class Response
    extends AcknowledgedResponse {
        public Response() {
        }

        public Response(boolean acknowledged) {
            super(acknowledged);
        }

        public void readFrom(StreamInput in) throws IOException {
            this.readAcknowledged(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.writeAcknowledged(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            AcknowledgedResponse that = (AcknowledgedResponse)o;
            return this.isAcknowledged() == that.isAcknowledged();
        }

        public int hashCode() {
            return Objects.hash(this.isAcknowledged());
        }
    }

    public static class JobParams
    implements PersistentTaskParams {
        public static final ParseField IGNORE_DOWNTIME = new ParseField("ignore_downtime", new String[0]);
        public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
        public static ObjectParser<JobParams, Void> PARSER = new ObjectParser("xpack/ml/job", JobParams::new);
        private String jobId;
        private boolean ignoreDowntime = true;
        private TimeValue timeout = MachineLearning.STATE_PERSIST_RESTORE_TIMEOUT;

        public static JobParams fromXContent(XContentParser parser) {
            return JobParams.parseRequest(null, parser);
        }

        public static JobParams parseRequest(String jobId, XContentParser parser) {
            JobParams params = (JobParams)PARSER.apply(parser, null);
            if (jobId != null) {
                params.jobId = jobId;
            }
            return params;
        }

        JobParams() {
        }

        public JobParams(String jobId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
        }

        public JobParams(StreamInput in) throws IOException {
            this.jobId = in.readString();
            this.ignoreDowntime = in.readBoolean();
            this.timeout = TimeValue.timeValueMillis((long)in.readVLong());
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public boolean isIgnoreDowntime() {
            return this.ignoreDowntime;
        }

        public void setIgnoreDowntime(boolean ignoreDowntime) {
            this.ignoreDowntime = ignoreDowntime;
        }

        public TimeValue getTimeout() {
            return this.timeout;
        }

        public void setTimeout(TimeValue timeout) {
            this.timeout = timeout;
        }

        public String getWriteableName() {
            return OpenJobAction.TASK_NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.jobId);
            out.writeBoolean(this.ignoreDowntime);
            out.writeVLong(this.timeout.millis());
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            builder.field(IGNORE_DOWNTIME.getPreferredName(), this.ignoreDowntime);
            builder.field(TIMEOUT.getPreferredName(), this.timeout.getStringRep());
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.ignoreDowntime, this.timeout);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            JobParams other = (JobParams)obj;
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.ignoreDowntime, other.ignoreDowntime) && Objects.equals(this.timeout, other.timeout);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        static {
            PARSER.declareString(JobParams::setJobId, Job.ID);
            PARSER.declareBoolean(JobParams::setIgnoreDowntime, IGNORE_DOWNTIME);
            PARSER.declareString((params, val) -> params.setTimeout(TimeValue.parseTimeValue((String)val, (String)TIMEOUT.getPreferredName())), TIMEOUT);
        }
    }

    public static class Request
    extends MasterNodeRequest<Request>
    implements ToXContent {
        private JobParams jobParams;

        public static Request fromXContent(XContentParser parser) {
            return Request.parseRequest(null, parser);
        }

        public static Request parseRequest(String jobId, XContentParser parser) {
            JobParams jobParams = (JobParams)JobParams.PARSER.apply(parser, null);
            if (jobId != null) {
                jobParams.jobId = jobId;
            }
            return new Request(jobParams);
        }

        public Request(JobParams jobParams) {
            this.jobParams = jobParams;
        }

        public Request(String jobId) {
            this.jobParams = new JobParams(jobId);
        }

        public Request(StreamInput in) throws IOException {
            this.readFrom(in);
        }

        Request() {
        }

        public JobParams getJobParams() {
            return this.jobParams;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobParams = new JobParams(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.jobParams.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.jobParams.toXContent(builder, params);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobParams);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobParams, other.jobParams);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }
}

