/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.TransportGetAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.MasterNodeReadOperationRequestBuilder;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.action.util.PageParams;
import org.elasticsearch.xpack.ml.action.util.QueryPage;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.config.MlFilter;
import org.elasticsearch.xpack.ml.job.persistence.JobProvider;

public class GetFiltersAction
extends Action<Request, Response, RequestBuilder> {
    public static final GetFiltersAction INSTANCE = new GetFiltersAction();
    public static final String NAME = "cluster:admin/xpack/ml/filters/get";

    private GetFiltersAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        private final TransportGetAction transportGetAction;
        private final TransportSearchAction transportSearchAction;

        @Inject
        public TransportAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobProvider jobProvider, JobManager jobManager, Client client, TransportGetAction transportGetAction, TransportSearchAction transportSearchAction) {
            super(settings, GetFiltersAction.NAME, threadPool, transportService, actionFilters, indexNameExpressionResolver, Request::new);
            this.transportGetAction = transportGetAction;
            this.transportSearchAction = transportSearchAction;
        }

        protected void doExecute(Request request, ActionListener<Response> listener) {
            String filterId = request.getFilterId();
            if (!Strings.isNullOrEmpty((String)filterId)) {
                this.getFilter(filterId, listener);
            } else if (request.getPageParams() != null) {
                this.getFilters(request.getPageParams(), listener);
            } else {
                throw new IllegalStateException("Both filterId and pageParams are null");
            }
        }

        private void getFilter(String filterId, final ActionListener<Response> listener) {
            GetRequest getRequest = new GetRequest(".ml-meta", MlFilter.TYPE.getPreferredName(), filterId);
            this.transportGetAction.execute((ActionRequest)getRequest, (ActionListener)new ActionListener<GetResponse>(){

                public void onResponse(GetResponse getDocResponse) {
                    try {
                        if (getDocResponse.isExists()) {
                            BytesReference docSource = getDocResponse.getSourceAsBytesRef();
                            XContentParser parser = XContentFactory.xContent((BytesReference)docSource).createParser(NamedXContentRegistry.EMPTY, docSource);
                            MlFilter filter = (MlFilter)((Object)MlFilter.PARSER.apply(parser, null));
                            QueryPage<MlFilter> responseBody = new QueryPage<MlFilter>(Collections.singletonList(filter), 1L, MlFilter.RESULTS_FIELD);
                            Response filterResponse = new Response(responseBody);
                            listener.onResponse((Object)filterResponse);
                        } else {
                            this.onFailure((Exception)QueryPage.emptyQueryPage(MlFilter.RESULTS_FIELD));
                        }
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }

        private void getFilters(PageParams pageParams, final ActionListener<Response> listener) {
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().from(pageParams.getFrom()).size(pageParams.getSize());
            SearchRequest searchRequest = new SearchRequest(new String[]{".ml-meta"}, sourceBuilder).indicesOptions(JobProvider.addIgnoreUnavailable(SearchRequest.DEFAULT_INDICES_OPTIONS)).types(new String[]{MlFilter.TYPE.getPreferredName()});
            this.transportSearchAction.execute((ActionRequest)searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse response) {
                    try {
                        ArrayList<Object> docs = new ArrayList<Object>();
                        for (SearchHit hit : response.getHits().getHits()) {
                            BytesReference docSource = hit.sourceRef();
                            XContentParser parser = XContentFactory.xContent((BytesReference)docSource).createParser(NamedXContentRegistry.EMPTY, docSource);
                            docs.add(MlFilter.PARSER.apply(parser, null));
                        }
                        Response filterResponse = new Response(new QueryPage<MlFilter>(docs, docs.size(), MlFilter.RESULTS_FIELD));
                        listener.onResponse((Object)filterResponse);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
    }

    public static class Response
    extends ActionResponse
    implements StatusToXContentObject {
        private QueryPage<MlFilter> filters;

        public Response(QueryPage<MlFilter> filters) {
            this.filters = filters;
        }

        Response() {
        }

        public QueryPage<MlFilter> getFilters() {
            return this.filters;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.filters = new QueryPage(in, MlFilter::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.filters.writeTo(out);
        }

        public RestStatus status() {
            return RestStatus.OK;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.filters.doXContentBody(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.filters});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.filters, other.filters);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    public static class RequestBuilder
    extends MasterNodeReadOperationRequestBuilder<Request, Response, RequestBuilder> {
        public RequestBuilder(ElasticsearchClient client, GetFiltersAction action) {
            super(client, (Action)action, (MasterNodeReadRequest)new Request());
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        private String filterId;
        private PageParams pageParams;

        public void setFilterId(String filterId) {
            if (this.pageParams != null) {
                throw new IllegalArgumentException("Param [" + MlFilter.ID.getPreferredName() + "] is incompatible with [" + PageParams.FROM.getPreferredName() + ", " + PageParams.SIZE.getPreferredName() + "].");
            }
            this.filterId = filterId;
        }

        public String getFilterId() {
            return this.filterId;
        }

        public PageParams getPageParams() {
            return this.pageParams;
        }

        public void setPageParams(PageParams pageParams) {
            if (this.filterId != null) {
                throw new IllegalArgumentException("Param [" + PageParams.FROM.getPreferredName() + ", " + PageParams.SIZE.getPreferredName() + "] is incompatible with [" + MlFilter.ID.getPreferredName() + "].");
            }
            this.pageParams = pageParams;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.pageParams == null && this.filterId == null) {
                validationException = ValidateActions.addValidationError((String)("Both [" + MlFilter.ID.getPreferredName() + "] and [" + PageParams.FROM.getPreferredName() + ", " + PageParams.SIZE.getPreferredName() + "] cannot be null"), validationException);
            }
            return validationException;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.filterId = in.readOptionalString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.filterId);
        }

        public int hashCode() {
            return Objects.hash(this.filterId);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.filterId, other.filterId);
        }
    }
}

