/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.action.util.PageParams;
import org.elasticsearch.xpack.ml.action.util.QueryPage;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.persistence.BucketsQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.JobProvider;
import org.elasticsearch.xpack.ml.job.results.Bucket;
import org.elasticsearch.xpack.ml.job.results.Result;
import org.elasticsearch.xpack.ml.utils.ExceptionsHelper;

public class GetBucketsAction
extends Action<Request, Response, RequestBuilder> {
    public static final GetBucketsAction INSTANCE = new GetBucketsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/job/results/buckets/get";

    private GetBucketsAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        private final JobProvider jobProvider;
        private final JobManager jobManager;
        private final Client client;

        @Inject
        public TransportAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, JobProvider jobProvider, JobManager jobManager, Client client) {
            super(settings, GetBucketsAction.NAME, threadPool, transportService, actionFilters, indexNameExpressionResolver, Request::new);
            this.jobProvider = jobProvider;
            this.jobManager = jobManager;
            this.client = client;
        }

        protected void doExecute(Request request, ActionListener<Response> listener) {
            this.jobManager.getJobOrThrowIfUnknown(request.getJobId());
            BucketsQueryBuilder query = new BucketsQueryBuilder().expand(request.expand).includeInterim(!request.excludeInterim).start(request.start).end(request.end).anomalyScoreThreshold(request.anomalyScore);
            if (request.pageParams != null) {
                query.from(request.pageParams.getFrom()).size(request.pageParams.getSize());
            }
            if (request.timestamp != null) {
                query.timestamp(request.timestamp);
            } else {
                query.start(request.start);
                query.end(request.end);
            }
            this.jobProvider.buckets(request.jobId, query.build(), q -> listener.onResponse((Object)new Response((QueryPage<Bucket>)((Object)q))), arg_0 -> listener.onFailure(arg_0), this.client);
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private QueryPage<Bucket> buckets;

        Response() {
        }

        Response(QueryPage<Bucket> buckets) {
            this.buckets = buckets;
        }

        public QueryPage<Bucket> getBuckets() {
            return this.buckets;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.buckets = new QueryPage(in, Bucket::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.buckets.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.buckets.doXContentBody(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.buckets});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.buckets, other.buckets);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client) {
            super(client, (Action)INSTANCE, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContent {
        public static final ParseField EXPAND = new ParseField("expand", new String[0]);
        public static final ParseField EXCLUDE_INTERIM = new ParseField("exclude_interim", new String[0]);
        public static final ParseField START = new ParseField("start", new String[0]);
        public static final ParseField END = new ParseField("end", new String[0]);
        public static final ParseField ANOMALY_SCORE = new ParseField("anomaly_score", new String[0]);
        public static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:monitor/xpack/ml/job/results/buckets/get", Request::new);
        private String jobId;
        private String timestamp;
        private boolean expand = false;
        private boolean excludeInterim = false;
        private String start;
        private String end;
        private PageParams pageParams;
        private Double anomalyScore;

        public static Request parseRequest(String jobId, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (jobId != null) {
                request.jobId = jobId;
            }
            return request;
        }

        Request() {
        }

        public Request(String jobId) {
            this.jobId = ExceptionsHelper.requireNonNull(jobId, Job.ID.getPreferredName());
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setTimestamp(String timestamp) {
            if (this.pageParams != null || this.start != null || this.end != null || this.anomalyScore != null) {
                throw new IllegalArgumentException("Param [" + TIMESTAMP.getPreferredName() + "] is incompatible with [" + PageParams.FROM.getPreferredName() + "," + PageParams.SIZE.getPreferredName() + "," + START.getPreferredName() + "," + END.getPreferredName() + "," + ANOMALY_SCORE.getPreferredName() + "]");
            }
            this.timestamp = ExceptionsHelper.requireNonNull(timestamp, Result.TIMESTAMP.getPreferredName());
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public boolean isExpand() {
            return this.expand;
        }

        public void setExpand(boolean expand) {
            this.expand = expand;
        }

        public boolean isExcludeInterim() {
            return this.excludeInterim;
        }

        public void setExcludeInterim(boolean excludeInterim) {
            this.excludeInterim = excludeInterim;
        }

        public String getStart() {
            return this.start;
        }

        public void setStart(String start) {
            if (this.timestamp != null) {
                throw new IllegalArgumentException("Param [" + START.getPreferredName() + "] is incompatible with [" + TIMESTAMP.getPreferredName() + "].");
            }
            this.start = start;
        }

        public String getEnd() {
            return this.end;
        }

        public void setEnd(String end) {
            if (this.timestamp != null) {
                throw new IllegalArgumentException("Param [" + END.getPreferredName() + "] is incompatible with [" + TIMESTAMP.getPreferredName() + "].");
            }
            this.end = end;
        }

        public PageParams getPageParams() {
            return this.pageParams;
        }

        public void setPageParams(PageParams pageParams) {
            if (this.timestamp != null) {
                throw new IllegalArgumentException("Param [" + PageParams.FROM.getPreferredName() + ", " + PageParams.SIZE.getPreferredName() + "] is incompatible with [" + TIMESTAMP.getPreferredName() + "].");
            }
            this.pageParams = ExceptionsHelper.requireNonNull(pageParams, PageParams.PAGE.getPreferredName());
        }

        public double getAnomalyScore() {
            return this.anomalyScore;
        }

        public void setAnomalyScore(double anomalyScore) {
            if (this.timestamp != null) {
                throw new IllegalArgumentException("Param [" + ANOMALY_SCORE.getPreferredName() + "] is incompatible with [" + TIMESTAMP.getPreferredName() + "].");
            }
            this.anomalyScore = anomalyScore;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobId = in.readString();
            this.timestamp = in.readOptionalString();
            this.expand = in.readBoolean();
            this.excludeInterim = in.readBoolean();
            this.start = in.readOptionalString();
            this.end = in.readOptionalString();
            this.anomalyScore = in.readOptionalDouble();
            this.pageParams = (PageParams)in.readOptionalWriteable(PageParams::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            out.writeOptionalString(this.timestamp);
            out.writeBoolean(this.expand);
            out.writeBoolean(this.excludeInterim);
            out.writeOptionalString(this.start);
            out.writeOptionalString(this.end);
            out.writeOptionalDouble(this.anomalyScore);
            out.writeOptionalWriteable((Writeable)this.pageParams);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            if (this.timestamp != null) {
                builder.field(Result.TIMESTAMP.getPreferredName(), this.timestamp);
            }
            builder.field(EXPAND.getPreferredName(), this.expand);
            builder.field(EXCLUDE_INTERIM.getPreferredName(), this.excludeInterim);
            if (this.start != null) {
                builder.field(START.getPreferredName(), this.start);
            }
            if (this.end != null) {
                builder.field(END.getPreferredName(), this.end);
            }
            if (this.pageParams != null) {
                builder.field(PageParams.PAGE.getPreferredName(), (ToXContent)this.pageParams);
            }
            if (this.anomalyScore != null) {
                builder.field(ANOMALY_SCORE.getPreferredName(), this.anomalyScore);
            }
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.jobId, this.timestamp, this.expand, this.excludeInterim, this.anomalyScore, this.pageParams, this.start, this.end});
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.expand, other.expand) && Objects.equals(this.excludeInterim, other.excludeInterim) && Objects.equals(this.anomalyScore, other.anomalyScore) && Objects.equals((Object)this.pageParams, (Object)other.pageParams) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end);
        }

        static {
            PARSER.declareString((request, jobId) -> {
                request.jobId = jobId;
            }, Job.ID);
            PARSER.declareString(Request::setTimestamp, Result.TIMESTAMP);
            PARSER.declareBoolean(Request::setExpand, EXPAND);
            PARSER.declareBoolean(Request::setExcludeInterim, EXCLUDE_INTERIM);
            PARSER.declareStringOrNull(Request::setStart, START);
            PARSER.declareStringOrNull(Request::setEnd, END);
            PARSER.declareObject(Request::setPageParams, PageParams.PARSER, PageParams.PAGE);
            PARSER.declareDouble(Request::setAnomalyScore, ANOMALY_SCORE);
        }
    }
}

