/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.MlMetadata;
import org.elasticsearch.xpack.ml.action.FinalizeJobExecutionAction;
import org.elasticsearch.xpack.ml.action.OpenJobAction;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.config.Job;
import org.elasticsearch.xpack.ml.job.config.JobState;
import org.elasticsearch.xpack.ml.job.config.JobTaskStatus;
import org.elasticsearch.xpack.ml.notifications.Auditor;
import org.elasticsearch.xpack.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.xpack.persistent.PersistentTasksService;
import org.elasticsearch.xpack.security.InternalClient;

public class CloseJobAction
extends Action<Request, Response, RequestBuilder> {
    public static final CloseJobAction INSTANCE = new CloseJobAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/close";

    private CloseJobAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    static List<String> resolveAndValidateJobId(String jobId, ClusterState state, boolean isForce) {
        MlMetadata mlMetadata = (MlMetadata)state.metaData().custom("ml");
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
        if (!"_all".equals(jobId)) {
            CloseJobAction.validateAndReturnJobTask(jobId, state, isForce);
            return Collections.singletonList(jobId);
        }
        if (mlMetadata.getJobs().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> matchedJobs = new ArrayList<String>();
        for (Map.Entry<String, Job> jobEntry : mlMetadata.getJobs().entrySet()) {
            PersistentTasksCustomMetaData.PersistentTask<?> jobTask;
            String resolvedJobId = jobEntry.getKey();
            Job job = jobEntry.getValue();
            if (job.isDeleted() || (jobTask = MlMetadata.getJobTask(resolvedJobId, tasks)) == null || !MlMetadata.getJobState(resolvedJobId, tasks).isAnyOf(JobState.OPENED, JobState.FAILED)) continue;
            CloseJobAction.validateAndReturnJobTask(resolvedJobId, state, isForce);
            matchedJobs.add(resolvedJobId);
        }
        return matchedJobs;
    }

    static PersistentTasksCustomMetaData.PersistentTask<?> validateAndReturnJobTask(String jobId, ClusterState state, boolean isForce) {
        DatafeedState datafeedState;
        MlMetadata mlMetadata = (MlMetadata)state.metaData().custom("ml");
        Job job = mlMetadata.getJobs().get(jobId);
        if (job == null) {
            throw new ResourceNotFoundException("cannot close job, because job [" + jobId + "] does not exist", new Object[0]);
        }
        PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)state.getMetaData().custom("persistent_tasks");
        PersistentTasksCustomMetaData.PersistentTask<?> jobTask = MlMetadata.getJobTask(jobId, tasks);
        if (jobTask == null || jobTask.getStatus() == null) {
            throw org.elasticsearch.xpack.ml.utils.ExceptionsHelper.conflictStatusException("cannot close job, because job [" + jobId + "] is " + (Object)((Object)JobState.CLOSED), new Object[0]);
        }
        JobTaskStatus jobTaskStatus = (JobTaskStatus)jobTask.getStatus();
        if (isForce ? !jobTaskStatus.getState().isAnyOf(JobState.OPENED, JobState.FAILED, JobState.CLOSING) : !jobTaskStatus.getState().isAnyOf(JobState.OPENED)) {
            throw org.elasticsearch.xpack.ml.utils.ExceptionsHelper.conflictStatusException("cannot close job, because job [" + jobId + "] is " + (Object)((Object)jobTaskStatus.getState()), new Object[0]);
        }
        Optional<DatafeedConfig> datafeed = mlMetadata.getDatafeedByJobId(jobId);
        if (datafeed.isPresent() && (datafeedState = MlMetadata.getDatafeedState(datafeed.get().getId(), tasks)) != DatafeedState.STOPPED) {
            throw org.elasticsearch.xpack.ml.utils.ExceptionsHelper.conflictStatusException("cannot close job [{}], datafeed hasn't been stopped", jobId);
        }
        return jobTask;
    }

    public static class TransportAction
    extends TransportTasksAction<OpenJobAction.JobTask, Request, Response, Response> {
        private final InternalClient client;
        private final ClusterService clusterService;
        private final Auditor auditor;
        private final PersistentTasksService persistentTasksService;

        @Inject
        public TransportAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, InternalClient client, Auditor auditor, PersistentTasksService persistentTasksService) {
            super(settings, CloseJobAction.NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, Request::new, Response::new, "same");
            this.client = client;
            this.clusterService = clusterService;
            this.auditor = auditor;
            this.persistentTasksService = persistentTasksService;
        }

        protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
            ClusterState state = this.clusterService.state();
            DiscoveryNodes nodes = state.nodes();
            if (!request.local && !nodes.isLocalNodeElectedMaster()) {
                if (nodes.getMasterNode() == null) {
                    listener.onFailure((Exception)new MasterNotDiscoveredException("no known master node"));
                } else {
                    this.transportService.sendRequest(nodes.getMasterNode(), this.actionName, (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, Response::new));
                }
            } else {
                Request.access$102(request, CloseJobAction.resolveAndValidateJobId(request.getJobId(), state, request.isForce()).toArray(new String[0]));
                if (request.resolvedJobIds.length == 0) {
                    listener.onResponse((Object)new Response(true));
                    return;
                }
                HashSet<String> executorNodes = new HashSet<String>();
                for (String resolvedJobId : request.resolvedJobIds) {
                    JobManager.getJobOrThrowIfUnknown(state, resolvedJobId);
                    PersistentTasksCustomMetaData tasks = (PersistentTasksCustomMetaData)state.metaData().custom("persistent_tasks");
                    PersistentTasksCustomMetaData.PersistentTask<?> jobTask = MlMetadata.getJobTask(resolvedJobId, tasks);
                    if (jobTask == null || !jobTask.isAssigned()) {
                        String message = "Cannot perform requested action because job [" + resolvedJobId + "] is not open";
                        listener.onFailure((Exception)org.elasticsearch.xpack.ml.utils.ExceptionsHelper.conflictStatusException(message, new Object[0]));
                        return;
                    }
                    executorNodes.add(jobTask.getExecutorNode());
                }
                request.setNodes(executorNodes.toArray(new String[executorNodes.size()]));
                if (request.isForce()) {
                    this.forceCloseJob(state, request, listener);
                } else {
                    this.normalCloseJob(state, task, request, listener);
                }
            }
        }

        protected void taskOperation(Request request, final OpenJobAction.JobTask jobTask, final ActionListener<Response> listener) {
            JobTaskStatus taskStatus = new JobTaskStatus(JobState.CLOSING, jobTask.getAllocationId());
            jobTask.updatePersistentStatus(taskStatus, ActionListener.wrap(task -> this.threadPool.executor("ml_utility").execute((Runnable)new AbstractRunnable(){

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }

                protected void doRun() throws Exception {
                    jobTask.closeJob("close job (api)");
                    listener.onResponse((Object)new Response(true));
                }
            }), arg_0 -> listener.onFailure(arg_0)));
        }

        protected boolean accumulateExceptions() {
            return true;
        }

        protected Response newResponse(Request request, List<Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
            if (request.resolvedJobIds.length != tasks.size()) {
                if (!taskOperationFailures.isEmpty()) {
                    throw ExceptionsHelper.convertToElastic((Exception)taskOperationFailures.get(0).getCause());
                }
                if (!failedNodeExceptions.isEmpty()) {
                    throw ExceptionsHelper.convertToElastic((Exception)((Exception)failedNodeExceptions.get(0)));
                }
                return new Response(true);
            }
            return new Response(tasks.stream().allMatch(Response::isClosed));
        }

        protected Response readTaskResponse(StreamInput in) throws IOException {
            return new Response(in);
        }

        private void forceCloseJob(ClusterState currentState, final Request request, final ActionListener<Response> listener) {
            final int numberOfJobs = request.resolvedJobIds.length;
            final AtomicInteger counter = new AtomicInteger();
            final AtomicArray failures = new AtomicArray(numberOfJobs);
            for (String jobId : request.resolvedJobIds) {
                this.auditor.info(jobId, "Job is closing (forced)");
                PersistentTasksCustomMetaData.PersistentTask<?> jobTask = CloseJobAction.validateAndReturnJobTask(jobId, currentState, true);
                this.persistentTasksService.cancelPersistentTask(jobTask.getId(), new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

                    public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> task) {
                        if (counter.incrementAndGet() == numberOfJobs) {
                            this.sendResponseOrFailure(request.getJobId(), (ActionListener<Response>)listener, (AtomicArray<Exception>)failures);
                        }
                    }

                    public void onFailure(Exception e) {
                        int slot = counter.incrementAndGet();
                        failures.set(slot - 1, (Object)e);
                        if (slot == numberOfJobs) {
                            this.sendResponseOrFailure(request.getJobId(), (ActionListener<Response>)listener, (AtomicArray<Exception>)failures);
                        }
                    }

                    private void sendResponseOrFailure(String jobId, ActionListener<Response> listener2, AtomicArray<Exception> failures2) {
                        List catchedExceptions = failures2.asList();
                        if (catchedExceptions.size() == 0) {
                            listener2.onResponse((Object)new Response(true));
                            return;
                        }
                        String msg = "Failed to force close job [" + jobId + "] with [" + catchedExceptions.size() + "] failures, rethrowing last, all Exceptions: [" + catchedExceptions.stream().map(Throwable::getMessage).collect(Collectors.joining(", ")) + "]";
                        ElasticsearchException e = new ElasticsearchException(msg, (Throwable)catchedExceptions.get(0), new Object[0]);
                        listener2.onFailure((Exception)e);
                    }
                });
            }
        }

        private void normalCloseJob(ClusterState currentState, Task task, Request request, ActionListener<Response> listener) {
            HashMap<String, String> jobIdToPersistentTaskId = new HashMap<String, String>();
            for (String jobId : request.resolvedJobIds) {
                this.auditor.info(jobId, "Job is closing");
                PersistentTasksCustomMetaData.PersistentTask<?> jobTask = CloseJobAction.validateAndReturnJobTask(jobId, currentState, false);
                jobIdToPersistentTaskId.put(jobId, jobTask.getId());
            }
            ActionListener finalListener = ActionListener.wrap(r -> this.waitForJobClosed(request, (Map<String, String>)jobIdToPersistentTaskId, (Response)((Object)r), listener), arg_0 -> listener.onFailure(arg_0));
            super.doExecute(task, (BaseTasksRequest)request, finalListener);
        }

        void waitForJobClosed(Request request, final Map<String, String> jobIdToPersistentTaskId, final Response response, final ActionListener<Response> listener) {
            this.persistentTasksService.waitForPersistentTasksStatus(persistentTasksCustomMetaData -> {
                for (Map.Entry entry : jobIdToPersistentTaskId.entrySet()) {
                    String persistentTaskId = (String)entry.getValue();
                    if (persistentTasksCustomMetaData.getTask(persistentTaskId) == null) continue;
                    return false;
                }
                return true;
            }, request.timeout, new ActionListener<Boolean>(){

                public void onResponse(Boolean result) {
                    Set jobIds = jobIdToPersistentTaskId.keySet();
                    FinalizeJobExecutionAction.Request finalizeRequest = new FinalizeJobExecutionAction.Request(jobIds.toArray(new String[jobIds.size()]));
                    client.execute(FinalizeJobExecutionAction.INSTANCE, (ActionRequest)finalizeRequest, (ActionListener)new ActionListener<FinalizeJobExecutionAction.Response>(){

                        public void onResponse(FinalizeJobExecutionAction.Response r) {
                            listener.onResponse((Object)response);
                        }

                        public void onFailure(Exception e) {
                            listener.onFailure(e);
                        }
                    });
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
    }

    public static class Response
    extends BaseTasksResponse
    implements Writeable,
    ToXContentObject {
        private boolean closed;

        Response() {
        }

        Response(StreamInput in) throws IOException {
            this.readFrom(in);
        }

        Response(boolean closed) {
            super(null, null);
            this.closed = closed;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.closed = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.closed);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("closed", this.closed);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.closed == response.closed;
        }

        public int hashCode() {
            return Objects.hash(this.closed);
        }
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client, CloseJobAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends BaseTasksRequest<Request>
    implements ToXContent {
        public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
        public static final ParseField FORCE = new ParseField("force", new String[0]);
        public static ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:admin/xpack/ml/job/close", Request::new);
        private String jobId;
        private boolean force = false;
        private TimeValue timeout = MachineLearning.STATE_PERSIST_RESTORE_TIMEOUT;
        private String[] resolvedJobIds;
        private boolean local;

        public static Request parseRequest(String jobId, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (jobId != null) {
                request.setJobId(jobId);
            }
            return request;
        }

        Request() {
        }

        public Request(String jobId) {
            this.jobId = jobId;
            this.resolvedJobIds = new String[]{jobId};
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
            this.resolvedJobIds = new String[]{jobId};
        }

        public TimeValue getCloseTimeout() {
            return this.timeout;
        }

        public void setCloseTimeout(TimeValue timeout) {
            this.timeout = timeout;
        }

        public boolean isForce() {
            return this.force;
        }

        public void setForce(boolean force) {
            this.force = force;
        }

        public void setLocal(boolean local) {
            this.local = local;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobId = in.readString();
            this.timeout = new TimeValue(in);
            this.force = in.readBoolean();
            this.resolvedJobIds = in.readStringArray();
            this.local = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.jobId);
            this.timeout.writeTo(out);
            out.writeBoolean(this.force);
            out.writeStringArray(this.resolvedJobIds);
            out.writeBoolean(this.local);
        }

        public boolean match(Task task) {
            for (String id : this.resolvedJobIds) {
                if (!OpenJobAction.JobTask.match(task, id)) continue;
                return true;
            }
            return false;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Job.ID.getPreferredName(), this.jobId);
            builder.field(TIMEOUT.getPreferredName(), this.timeout.getStringRep());
            builder.field(FORCE.getPreferredName(), this.force);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.timeout, this.force);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobId, other.jobId) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.force, other.force);
        }

        static /* synthetic */ String[] access$102(Request x0, String[] x1) {
            x0.resolvedJobIds = x1;
            return x1;
        }

        static {
            PARSER.declareString(Request::setJobId, Job.ID);
            PARSER.declareString((request, val) -> request.setCloseTimeout(TimeValue.parseTimeValue((String)val, (String)TIMEOUT.getPreferredName())), TIMEOUT);
            PARSER.declareBoolean(Request::setForce, FORCE);
        }
    }
}

