/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.transport.Transports;

public final class Netty4WriteThrottlingHandler
extends ChannelDuplexHandler {
    private final Queue<WriteOperation> queuedWrites = new ArrayDeque<WriteOperation>();
    private final ThreadContext threadContext;
    private WriteOperation currentWrite;

    public Netty4WriteThrottlingHandler(ThreadContext threadContext) {
        this.threadContext = threadContext;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        assert (msg instanceof ByteBuf);
        assert (Transports.assertDefaultThreadContext((ThreadContext)this.threadContext));
        assert (Transports.assertTransportThread());
        boolean queued = this.queuedWrites.offer(new WriteOperation((ByteBuf)msg, promise));
        assert (queued);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        if (ctx.channel().isWritable()) {
            this.doFlush(ctx);
        }
        ctx.fireChannelWritabilityChanged();
    }

    public void flush(ChannelHandlerContext ctx) {
        if (!this.doFlush(ctx)) {
            ctx.flush();
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.doFlush(ctx);
        super.channelInactive(ctx);
    }

    private boolean doFlush(ChannelHandlerContext ctx) {
        assert (ctx.executor().inEventLoop());
        Channel channel = ctx.channel();
        if (!channel.isActive()) {
            this.failQueuedWrites();
            return false;
        }
        boolean needsFlush = true;
        while (channel.isWritable()) {
            ByteBuf writeBuffer;
            boolean sliced;
            if (this.currentWrite == null) {
                this.currentWrite = this.queuedWrites.poll();
            }
            if (this.currentWrite == null) break;
            WriteOperation write = this.currentWrite;
            int readableBytes = write.buf.readableBytes();
            int bufferSize = Math.min(readableBytes, 262144);
            int readerIndex = write.buf.readerIndex();
            boolean bl = sliced = readableBytes != bufferSize;
            if (sliced) {
                writeBuffer = write.buf.retainedSlice(readerIndex, bufferSize);
                write.buf.readerIndex(readerIndex + bufferSize);
            } else {
                writeBuffer = write.buf;
            }
            ChannelFuture writeFuture = ctx.write((Object)writeBuffer);
            needsFlush = true;
            if (!sliced) {
                this.currentWrite = null;
                writeFuture.addListener(future -> {
                    assert (ctx.executor().inEventLoop());
                    if (future.isSuccess()) {
                        write.promise.trySuccess();
                    } else {
                        write.promise.tryFailure(future.cause());
                    }
                });
            } else {
                writeFuture.addListener(future -> {
                    assert (ctx.executor().inEventLoop());
                    if (!future.isSuccess()) {
                        write.promise.tryFailure(future.cause());
                    }
                });
            }
            if (channel.isWritable()) continue;
            ctx.flush();
            needsFlush = false;
        }
        if (needsFlush) {
            ctx.flush();
        }
        if (!channel.isActive()) {
            this.failQueuedWrites();
        }
        return true;
    }

    private void failQueuedWrites() {
        WriteOperation queuedWrite;
        if (this.currentWrite != null) {
            WriteOperation current = this.currentWrite;
            this.currentWrite = null;
            current.failAsClosedChannel();
        }
        while ((queuedWrite = this.queuedWrites.poll()) != null) {
            queuedWrite.failAsClosedChannel();
        }
    }

    private record WriteOperation(ByteBuf buf, ChannelPromise promise) {
        void failAsClosedChannel() {
            this.promise.tryFailure((Throwable)new ClosedChannelException());
            this.buf.release();
        }
    }
}

