/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import java.util.function.Predicate;
import org.elasticsearch.http.HttpPreRequest;
import org.elasticsearch.http.netty4.internal.HttpHeadersAuthenticatorUtils;

public class Netty4HttpAggregator
extends HttpObjectAggregator {
    private static final Predicate<HttpPreRequest> IGNORE_TEST = req -> !req.uri().startsWith("/_test/request-stream");
    private final Predicate<HttpPreRequest> decider;
    private boolean aggregating = true;
    private boolean ignoreContentAfterContinueResponse = false;

    public Netty4HttpAggregator(int maxContentLength, Predicate<HttpPreRequest> decider) {
        super(maxContentLength);
        this.decider = decider;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        assert (msg instanceof HttpObject);
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            HttpPreRequest preReq = HttpHeadersAuthenticatorUtils.asHttpPreRequest(request);
            boolean bl = this.aggregating = this.decider.test(preReq) && IGNORE_TEST.test(preReq) || request.decoderResult().isFailure();
        }
        if (this.aggregating || msg instanceof FullHttpRequest) {
            super.channelRead(ctx, msg);
        } else {
            this.handle(ctx, (HttpObject)msg);
        }
    }

    private void handle(ChannelHandlerContext ctx, HttpObject msg) {
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            Object continueResponse = this.newContinueResponse((HttpMessage)request, this.maxContentLength(), ctx.pipeline());
            if (continueResponse != null) {
                ctx.writeAndFlush(continueResponse);
                FullHttpResponse resp = (FullHttpResponse)continueResponse;
                if (resp.status() != HttpResponseStatus.CONTINUE) {
                    this.ignoreContentAfterContinueResponse = true;
                    return;
                }
                HttpUtil.set100ContinueExpected((HttpMessage)request, (boolean)false);
            }
            this.ignoreContentAfterContinueResponse = false;
            ctx.fireChannelRead((Object)msg);
        } else {
            HttpContent httpContent = (HttpContent)msg;
            if (this.ignoreContentAfterContinueResponse) {
                httpContent.release();
            } else {
                ctx.fireChannelRead((Object)msg);
            }
        }
    }
}

