/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.http.AbstractHttpServerTransport;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpHandlingSettings;
import org.elasticsearch.http.HttpReadTimeoutException;
import org.elasticsearch.http.HttpServerChannel;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.http.netty4.Netty4FullHttpResponse;
import org.elasticsearch.http.netty4.Netty4HttpChannel;
import org.elasticsearch.http.netty4.Netty4HttpPipeliningHandler;
import org.elasticsearch.http.netty4.Netty4HttpServerChannel;
import org.elasticsearch.http.netty4.internal.HttpHeadersAuthenticatorUtils;
import org.elasticsearch.http.netty4.internal.HttpValidator;
import org.elasticsearch.telemetry.tracing.Tracer;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.netty4.AcceptChannelHandler;
import org.elasticsearch.transport.netty4.NetUtils;
import org.elasticsearch.transport.netty4.Netty4Plugin;
import org.elasticsearch.transport.netty4.Netty4Utils;
import org.elasticsearch.transport.netty4.Netty4WriteThrottlingHandler;
import org.elasticsearch.transport.netty4.NettyAllocator;
import org.elasticsearch.transport.netty4.NettyByteBufSizer;
import org.elasticsearch.transport.netty4.SSLExceptionHelper;
import org.elasticsearch.transport.netty4.SharedGroupFactory;
import org.elasticsearch.transport.netty4.TLSConfig;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class Netty4HttpServerTransport
extends AbstractHttpServerTransport {
    private static final Logger logger = LogManager.getLogger(Netty4HttpServerTransport.class);
    private final int pipeliningMaxEvents;
    private final SharedGroupFactory sharedGroupFactory;
    private final RecvByteBufAllocator recvByteBufAllocator;
    private final TLSConfig tlsConfig;
    private final AcceptChannelHandler.AcceptPredicate acceptChannelPredicate;
    private final HttpValidator httpValidator;
    private final int readTimeoutMillis;
    private final int maxCompositeBufferComponents;
    private volatile ServerBootstrap serverBootstrap;
    private volatile SharedGroupFactory.SharedGroup sharedGroup;
    static final AttributeKey<Netty4HttpChannel> HTTP_CHANNEL_KEY = AttributeKey.newInstance((String)"es-http-channel");
    static final AttributeKey<Netty4HttpServerChannel> HTTP_SERVER_CHANNEL_KEY = AttributeKey.newInstance((String)"es-http-server-channel");

    public Netty4HttpServerTransport(Settings settings, NetworkService networkService, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, HttpServerTransport.Dispatcher dispatcher, ClusterSettings clusterSettings, SharedGroupFactory sharedGroupFactory, Tracer tracer, TLSConfig tlsConfig, @Nullable AcceptChannelHandler.AcceptPredicate acceptChannelPredicate, @Nullable HttpValidator httpValidator) {
        super(settings, networkService, Netty4Utils.createRecycler(settings), threadPool, xContentRegistry, dispatcher, clusterSettings, tracer);
        Netty4Utils.setAvailableProcessors(EsExecutors.allocatedProcessors((Settings)settings));
        NettyAllocator.logAllocatorDescriptionIfNeeded();
        this.sharedGroupFactory = sharedGroupFactory;
        this.tlsConfig = tlsConfig;
        this.acceptChannelPredicate = acceptChannelPredicate;
        this.httpValidator = httpValidator;
        this.pipeliningMaxEvents = (Integer)HttpTransportSettings.SETTING_PIPELINING_MAX_EVENTS.get(settings);
        this.maxCompositeBufferComponents = (Integer)Netty4Plugin.SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS.get(settings);
        this.readTimeoutMillis = Math.toIntExact(((TimeValue)HttpTransportSettings.SETTING_HTTP_READ_TIMEOUT.get(settings)).getMillis());
        ByteSizeValue receivePredictor = (ByteSizeValue)Netty4Plugin.SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE.get(settings);
        this.recvByteBufAllocator = new FixedRecvByteBufAllocator(receivePredictor.bytesAsInt());
        logger.debug("using max_chunk_size[{}], max_header_size[{}], max_initial_line_length[{}], max_content_length[{}], receive_predictor[{}], max_composite_buffer_components[{}], pipelining_max_events[{}]", HttpTransportSettings.SETTING_HTTP_MAX_CHUNK_SIZE.get(settings), HttpTransportSettings.SETTING_HTTP_MAX_HEADER_SIZE.get(settings), HttpTransportSettings.SETTING_HTTP_MAX_INITIAL_LINE_LENGTH.get(settings), (Object)this.maxContentLength, (Object)receivePredictor, (Object)this.maxCompositeBufferComponents, (Object)this.pipeliningMaxEvents);
    }

    public Settings settings() {
        return this.settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() {
        boolean success = false;
        try {
            ByteSizeValue tcpReceiveBufferSize;
            ByteSizeValue tcpSendBufferSize;
            this.sharedGroup = this.sharedGroupFactory.getHttpGroup();
            this.serverBootstrap = new ServerBootstrap();
            this.serverBootstrap.group(this.sharedGroup.getLowLevelGroup());
            this.serverBootstrap.channel(NettyAllocator.getServerChannelType());
            this.serverBootstrap.option(ChannelOption.ALLOCATOR, (Object)NettyAllocator.getAllocator());
            this.serverBootstrap.childOption(ChannelOption.ALLOCATOR, (Object)NettyAllocator.getAllocator());
            this.serverBootstrap.childHandler(this.configureServerChannelHandler());
            this.serverBootstrap.handler((ChannelHandler)ServerChannelExceptionHandler.INSTANCE);
            this.serverBootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)((Boolean)HttpTransportSettings.SETTING_HTTP_TCP_NO_DELAY.get(this.settings)));
            this.serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)((Boolean)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_ALIVE.get(this.settings)));
            if (((Boolean)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_ALIVE.get(this.settings)).booleanValue() && (IOUtils.LINUX || IOUtils.MAC_OS_X)) {
                if ((Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_IDLE.get(this.settings) >= 0) {
                    this.serverBootstrap.childOption(NioChannelOption.of(NetUtils.getTcpKeepIdleSocketOption()), (Object)((Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_IDLE.get(this.settings)));
                }
                if ((Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_INTERVAL.get(this.settings) >= 0) {
                    this.serverBootstrap.childOption(NioChannelOption.of(NetUtils.getTcpKeepIntervalSocketOption()), (Object)((Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_INTERVAL.get(this.settings)));
                }
                if ((Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_COUNT.get(this.settings) >= 0) {
                    this.serverBootstrap.childOption(NioChannelOption.of(NetUtils.getTcpKeepCountSocketOption()), (Object)((Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_COUNT.get(this.settings)));
                }
            }
            if ((tcpSendBufferSize = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_TCP_SEND_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
                this.serverBootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)Math.toIntExact(tcpSendBufferSize.getBytes()));
            }
            if ((tcpReceiveBufferSize = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_TCP_RECEIVE_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
                this.serverBootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)Math.toIntExact(tcpReceiveBufferSize.getBytes()));
            }
            this.serverBootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
            this.serverBootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
            boolean reuseAddress = (Boolean)HttpTransportSettings.SETTING_HTTP_TCP_REUSE_ADDRESS.get(this.settings);
            this.serverBootstrap.option(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
            this.serverBootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
            this.bindServer();
            if (this.acceptChannelPredicate != null) {
                this.acceptChannelPredicate.setBoundAddress(this.boundAddress());
            }
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    protected HttpServerChannel bind(InetSocketAddress socketAddress) throws Exception {
        ChannelFuture future = this.serverBootstrap.bind((SocketAddress)socketAddress).sync();
        Channel channel = future.channel();
        Netty4HttpServerChannel httpServerChannel = new Netty4HttpServerChannel(channel);
        channel.attr(HTTP_SERVER_CHANNEL_KEY).set((Object)httpServerChannel);
        return httpServerChannel;
    }

    protected void stopInternal() {
        if (this.sharedGroup != null) {
            this.sharedGroup.shutdown();
            this.sharedGroup = null;
        }
    }

    public void onException(HttpChannel channel, Exception cause) {
        if (!this.lifecycle.started()) {
            return;
        }
        if (SSLExceptionHelper.isNotSslRecordException(cause)) {
            logger.warn("received plaintext http traffic on an https channel, closing connection {}", (Object)channel);
            CloseableChannel.closeChannel((CloseableChannel)channel);
        } else if (SSLExceptionHelper.isCloseDuringHandshakeException(cause)) {
            logger.debug("connection {} closed during ssl handshake", (Object)channel);
            CloseableChannel.closeChannel((CloseableChannel)channel);
        } else if (SSLExceptionHelper.isInsufficientBufferRemainingException(cause)) {
            logger.debug("connection {} closed abruptly", (Object)channel);
            CloseableChannel.closeChannel((CloseableChannel)channel);
        } else if (SSLExceptionHelper.isReceivedCertificateUnknownException(cause)) {
            logger.warn("http client did not trust this server's certificate, closing connection {}", (Object)channel);
            CloseableChannel.closeChannel((CloseableChannel)channel);
        } else if (cause instanceof ReadTimeoutException) {
            super.onException(channel, (Exception)new HttpReadTimeoutException((long)this.readTimeoutMillis, cause));
        } else {
            super.onException(channel, cause);
        }
    }

    public ChannelHandler configureServerChannelHandler() {
        return new HttpChannelHandler(this, this.handlingSettings, this.tlsConfig, this.acceptChannelPredicate, this.httpValidator);
    }

    @ChannelHandler.Sharable
    private static class ServerChannelExceptionHandler
    extends ChannelInboundHandlerAdapter {
        static final ServerChannelExceptionHandler INSTANCE = new ServerChannelExceptionHandler();

        private ServerChannelExceptionHandler() {
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
            Netty4HttpServerChannel httpServerChannel = (Netty4HttpServerChannel)ctx.channel().attr(HTTP_SERVER_CHANNEL_KEY).get();
            if (cause instanceof Error) {
                Netty4HttpServerTransport.onServerException((HttpServerChannel)httpServerChannel, (Exception)new Exception(cause));
            } else {
                Netty4HttpServerTransport.onServerException((HttpServerChannel)httpServerChannel, (Exception)((Exception)cause));
            }
        }
    }

    protected static class HttpChannelHandler
    extends ChannelInitializer<Channel> {
        private final Netty4HttpServerTransport transport;
        private final HttpHandlingSettings handlingSettings;
        private final TLSConfig tlsConfig;
        private final BiPredicate<String, InetSocketAddress> acceptChannelPredicate;
        private final HttpValidator httpValidator;

        protected HttpChannelHandler(Netty4HttpServerTransport transport, HttpHandlingSettings handlingSettings, TLSConfig tlsConfig, @Nullable BiPredicate<String, InetSocketAddress> acceptChannelPredicate, @Nullable HttpValidator httpValidator) {
            this.transport = transport;
            this.handlingSettings = handlingSettings;
            this.tlsConfig = tlsConfig;
            this.acceptChannelPredicate = acceptChannelPredicate;
            this.httpValidator = httpValidator;
        }

        protected void initChannel(Channel ch) throws Exception {
            Netty4HttpChannel nettyHttpChannel = new Netty4HttpChannel(ch);
            ch.attr(HTTP_CHANNEL_KEY).set((Object)nettyHttpChannel);
            if (this.acceptChannelPredicate != null) {
                ch.pipeline().addLast("accept_channel_handler", (ChannelHandler)new AcceptChannelHandler(this.acceptChannelPredicate, ".http", this.transport.getThreadPool().getThreadContext()));
            }
            if (this.tlsConfig.isTLSEnabled()) {
                ch.pipeline().addLast("ssl", (ChannelHandler)new SslHandler(this.tlsConfig.createServerSSLEngine()));
            }
            ch.pipeline().addLast("chunked_writer", (ChannelHandler)new Netty4WriteThrottlingHandler(this.transport.getThreadPool().getThreadContext())).addLast("byte_buf_sizer", (ChannelHandler)NettyByteBufSizer.INSTANCE);
            if (this.transport.readTimeoutMillis > 0) {
                ch.pipeline().addLast("read_timeout", (ChannelHandler)new ReadTimeoutHandler((long)this.transport.readTimeoutMillis, TimeUnit.MILLISECONDS));
            }
            HttpRequestDecoder decoder = this.httpValidator != null ? new HttpRequestDecoder(this.handlingSettings.maxInitialLineLength(), this.handlingSettings.maxHeaderSize(), this.handlingSettings.maxChunkSize()){

                protected HttpMessage createMessage(String[] initialLine) throws Exception {
                    return HttpHeadersAuthenticatorUtils.wrapAsMessageWithAuthenticationContext(super.createMessage(initialLine));
                }
            } : new HttpRequestDecoder(this.handlingSettings.maxInitialLineLength(), this.handlingSettings.maxHeaderSize(), this.handlingSettings.maxChunkSize());
            decoder.setCumulator(ByteToMessageDecoder.COMPOSITE_CUMULATOR);
            ch.pipeline().addLast("decoder", (ChannelHandler)decoder);
            if (this.httpValidator != null) {
                ch.pipeline().addLast("header_validator", (ChannelHandler)HttpHeadersAuthenticatorUtils.getValidatorInboundHandler(this.httpValidator, this.transport.getThreadPool().getThreadContext()));
            }
            HttpObjectAggregator aggregator = new HttpObjectAggregator(this.handlingSettings.maxContentLength());
            aggregator.setMaxCumulationBufferComponents(this.transport.maxCompositeBufferComponents);
            ch.pipeline().addLast("decoder_compress", (ChannelHandler)new HttpContentDecompressor()).addLast("encoder", (ChannelHandler)new HttpResponseEncoder(){

                protected boolean isContentAlwaysEmpty(HttpResponse msg) {
                    if (msg instanceof Netty4FullHttpResponse) {
                        Netty4FullHttpResponse netty4FullHttpResponse = (Netty4FullHttpResponse)msg;
                        if (HttpUtil.isTransferEncodingChunked((HttpMessage)msg)) {
                            assert (!netty4FullHttpResponse.content().isReadable());
                            return true;
                        }
                    }
                    return super.isContentAlwaysEmpty(msg);
                }
            }).addLast("aggregator", (ChannelHandler)aggregator);
            if (this.handlingSettings.compression()) {
                ch.pipeline().addLast("encoder_compress", (ChannelHandler)new HttpContentCompressor(this.handlingSettings.compressionLevel()));
            }
            ch.pipeline().addLast("pipelining", (ChannelHandler)new Netty4HttpPipeliningHandler(this.transport.pipeliningMaxEvents, this.transport));
            this.transport.serverAcceptedChannel(nettyHttpChannel);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
            super.exceptionCaught(ctx, cause);
        }
    }
}

