/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.ParseFieldMatcherSupplier;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.indices.query.IndicesQueriesRegistry;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.search.RestSearchAction;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestStatusToXContentListener;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.mustache.SearchTemplateAction;
import org.elasticsearch.script.mustache.SearchTemplateRequest;
import org.elasticsearch.search.aggregations.AggregatorParsers;
import org.elasticsearch.search.suggest.Suggesters;

public class RestSearchTemplateAction
extends BaseRestHandler {
    private static ObjectParser<SearchTemplateRequest, ParseFieldMatcherSupplier> PARSER = new ObjectParser("search_template");
    private final IndicesQueriesRegistry queryRegistry;
    private final AggregatorParsers aggParsers;
    private final Suggesters suggesters;

    @Inject
    public RestSearchTemplateAction(Settings settings, RestController controller, IndicesQueriesRegistry queryRegistry, AggregatorParsers aggregatorParsers, Suggesters suggesters) {
        super(settings);
        this.queryRegistry = queryRegistry;
        this.aggParsers = aggregatorParsers;
        this.suggesters = suggesters;
        controller.registerHandler(RestRequest.Method.GET, "/_search/template", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_search/template", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_search/template", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_search/template", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_search/template", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_search/template", (RestHandler)this);
    }

    public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        if (!RestActions.hasBodyContent((RestRequest)request)) {
            throw new ElasticsearchException("request body is required", new Object[0]);
        }
        SearchRequest searchRequest = new SearchRequest();
        RestSearchAction.parseSearchRequest((SearchRequest)searchRequest, (IndicesQueriesRegistry)this.queryRegistry, (RestRequest)request, (ParseFieldMatcher)this.parseFieldMatcher, (AggregatorParsers)this.aggParsers, (Suggesters)this.suggesters, null);
        SearchTemplateRequest searchTemplateRequest = RestSearchTemplateAction.parse(RestActions.getRestContent((RestRequest)request));
        searchTemplateRequest.setRequest(searchRequest);
        client.execute((Action)SearchTemplateAction.INSTANCE, (ActionRequest)searchTemplateRequest, (ActionListener)new RestStatusToXContentListener(channel));
    }

    public static SearchTemplateRequest parse(BytesReference bytes) throws IOException {
        try (XContentParser parser = XContentHelper.createParser((BytesReference)bytes);){
            SearchTemplateRequest searchTemplateRequest = (SearchTemplateRequest)((Object)PARSER.parse(parser, (Object)new SearchTemplateRequest(), () -> ParseFieldMatcher.STRICT));
            return searchTemplateRequest;
        }
    }

    static {
        PARSER.declareField((parser, request, s) -> request.setScriptParams(parser.map()), new ParseField("params", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareString((request, s) -> {
            request.setScriptType(ScriptService.ScriptType.FILE);
            request.setScript((String)s);
        }, new ParseField("file", new String[0]));
        PARSER.declareString((request, s) -> {
            request.setScriptType(ScriptService.ScriptType.STORED);
            request.setScript((String)s);
        }, new ParseField("id", new String[0]));
        PARSER.declareField((parser, request, value) -> {
            block15: {
                request.setScriptType(ScriptService.ScriptType.INLINE);
                if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                    try (XContentBuilder builder = XContentFactory.contentBuilder((XContentType)parser.contentType());){
                        request.setScript(builder.copyCurrentStructure(parser).bytes().utf8ToString());
                        break block15;
                    }
                    catch (IOException e) {
                        throw new ParsingException(parser.getTokenLocation(), "Could not parse inline template", (Throwable)e, new Object[0]);
                    }
                }
                request.setScript(parser.text());
            }
        }, new ParseField("inline", new String[]{"template"}), ObjectParser.ValueType.OBJECT_OR_STRING);
    }
}

