/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import com.github.mustachejava.Mustache;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.Permission;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.io.UTF8StreamWriter;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.GeneralScriptException;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.script.mustache.CustomMustacheFactory;
import org.elasticsearch.search.lookup.SearchLookup;

public final class MustacheScriptEngineService
extends AbstractComponent
implements ScriptEngineService {
    public static final String NAME = "mustache";
    static final String CONTENT_TYPE_PARAM = "content_type";
    static final String JSON_CONTENT_TYPE = "application/json";
    static final String PLAIN_TEXT_CONTENT_TYPE = "text/plain";
    private static ThreadLocal<SoftReference<UTF8StreamWriter>> utf8StreamWriter = new ThreadLocal();
    static final SpecialPermission SPECIAL_PERMISSION = new SpecialPermission();

    private static UTF8StreamWriter utf8StreamWriter() {
        UTF8StreamWriter writer;
        SoftReference<UTF8StreamWriter> ref = utf8StreamWriter.get();
        UTF8StreamWriter uTF8StreamWriter = writer = ref == null ? null : ref.get();
        if (writer == null) {
            writer = new UTF8StreamWriter(4096);
            utf8StreamWriter.set(new SoftReference<UTF8StreamWriter>(writer));
        }
        writer.reset();
        return writer;
    }

    public MustacheScriptEngineService(Settings settings) {
        super(settings);
    }

    public Object compile(String templateName, String templateSource, Map<String, String> params) {
        CustomMustacheFactory factory = new CustomMustacheFactory(this.isJsonEscapingEnabled(params));
        FastStringReader reader = new FastStringReader(templateSource);
        return factory.compile((Reader)reader, "query-template");
    }

    private boolean isJsonEscapingEnabled(Map<String, String> params) {
        return JSON_CONTENT_TYPE.equals(params.getOrDefault(CONTENT_TYPE_PARAM, JSON_CONTENT_TYPE));
    }

    public String getType() {
        return NAME;
    }

    public String getExtension() {
        return NAME;
    }

    public ExecutableScript executable(CompiledScript compiledScript, @Nullable Map<String, Object> vars) {
        return new MustacheExecutableScript(compiledScript, vars);
    }

    public SearchScript search(CompiledScript compiledScript, SearchLookup lookup, @Nullable Map<String, Object> vars) {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    public boolean isInlineScriptEnabled() {
        return true;
    }

    private class MustacheExecutableScript
    implements ExecutableScript {
        private CompiledScript template;
        private Map<String, Object> vars;

        public MustacheExecutableScript(CompiledScript template, Map<String, Object> vars) {
            this.template = template;
            this.vars = vars == null ? Collections.emptyMap() : vars;
        }

        public void setNextVar(String name, Object value) {
            this.vars.put(name, value);
        }

        public Object run() {
            BytesStreamOutput result = new BytesStreamOutput();
            try (UTF8StreamWriter writer = MustacheScriptEngineService.utf8StreamWriter().setOutput((OutputStream)result);){
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission((Permission)SPECIAL_PERMISSION);
                }
                AccessController.doPrivileged(() -> {
                    ((Mustache)this.template.compiled()).execute((Writer)writer, this.vars);
                    return null;
                });
            }
            catch (Exception e) {
                MustacheScriptEngineService.this.logger.error("Error running {}", (Throwable)e, new Object[]{this.template});
                throw new GeneralScriptException("Error running " + this.template, (Throwable)e);
            }
            return result.bytes();
        }
    }
}

