/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import com.maxmind.geoip2.DatabaseReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.geoip.GeoIpProcessor;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.Plugin;

public class IngestGeoIpPlugin
extends Plugin
implements IngestPlugin,
Closeable {
    private Map<String, DatabaseReader> databaseReaders;

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        if (this.databaseReaders != null) {
            throw new IllegalStateException("called onModule twice for geoip plugin!!");
        }
        Path geoIpConfigDirectory = parameters.env.configFile().resolve("ingest-geoip");
        try {
            this.databaseReaders = IngestGeoIpPlugin.loadDatabaseReaders(geoIpConfigDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Collections.singletonMap("geoip", new GeoIpProcessor.Factory(this.databaseReaders));
    }

    static Map<String, DatabaseReader> loadDatabaseReaders(Path geoIpConfigDirectory) throws IOException {
        if (!Files.exists(geoIpConfigDirectory, new LinkOption[0]) && Files.isDirectory(geoIpConfigDirectory, new LinkOption[0])) {
            throw new IllegalStateException("the geoip directory [" + geoIpConfigDirectory + "] containing databases doesn't exist");
        }
        HashMap<String, DatabaseReader> databaseReaders = new HashMap<String, DatabaseReader>();
        try (Stream<Path> databaseFiles = Files.list(geoIpConfigDirectory);){
            PathMatcher pathMatcher = geoIpConfigDirectory.getFileSystem().getPathMatcher("glob:**.mmdb.gz");
            Iterator iterator = databaseFiles.iterator();
            while (iterator.hasNext()) {
                Path databasePath = (Path)iterator.next();
                if (!Files.isRegularFile(databasePath, new LinkOption[0]) || !pathMatcher.matches(databasePath)) continue;
                GZIPInputStream inputStream = new GZIPInputStream(Files.newInputStream(databasePath, StandardOpenOption.READ));
                Throwable throwable = null;
                try {
                    databaseReaders.put(databasePath.getFileName().toString(), new DatabaseReader.Builder((InputStream)inputStream).build());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)inputStream).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)inputStream).close();
                }
            }
        }
        return Collections.unmodifiableMap(databaseReaders);
    }

    @Override
    public void close() throws IOException {
        if (this.databaseReaders != null) {
            IOUtils.close(this.databaseReaders.values());
        }
    }
}

