/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Continent;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Subdivision;
import java.io.IOException;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.Permission;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public final class GeoIpProcessor
extends AbstractProcessor {
    public static final String TYPE = "geoip";
    private static final String CITY_DB_TYPE = "GeoLite2-City";
    private static final String COUNTRY_DB_TYPE = "GeoLite2-Country";
    private final String field;
    private final String targetField;
    private final DatabaseReader dbReader;
    private final Set<Property> properties;

    GeoIpProcessor(String tag, String field, DatabaseReader dbReader, String targetField, Set<Property> properties) throws IOException {
        super(tag);
        this.field = field;
        this.targetField = targetField;
        this.dbReader = dbReader;
        this.properties = properties;
    }

    public void execute(IngestDocument ingestDocument) {
        Map<String, Object> geoData;
        String ip = (String)ingestDocument.getFieldValue(this.field, String.class);
        InetAddress ipAddress = InetAddresses.forString((String)ip);
        switch (this.dbReader.getMetadata().getDatabaseType()) {
            case "GeoLite2-City": {
                try {
                    geoData = this.retrieveCityGeoData(ipAddress);
                }
                catch (AddressNotFoundRuntimeException e) {
                    geoData = Collections.emptyMap();
                }
                break;
            }
            case "GeoLite2-Country": {
                try {
                    geoData = this.retrieveCountryGeoData(ipAddress);
                }
                catch (AddressNotFoundRuntimeException e) {
                    geoData = Collections.emptyMap();
                }
                break;
            }
            default: {
                throw new ElasticsearchParseException("Unsupported database type [" + this.dbReader.getMetadata().getDatabaseType() + "]", (Throwable)new IllegalStateException(), new Object[0]);
            }
        }
        ingestDocument.setFieldValue(this.targetField, geoData);
    }

    public String getType() {
        return TYPE;
    }

    String getField() {
        return this.field;
    }

    String getTargetField() {
        return this.targetField;
    }

    DatabaseReader getDbReader() {
        return this.dbReader;
    }

    Set<Property> getProperties() {
        return this.properties;
    }

    private Map<String, Object> retrieveCityGeoData(InetAddress ipAddress) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        CityResponse response = AccessController.doPrivileged(() -> {
            try {
                return this.dbReader.city(ipAddress);
            }
            catch (AddressNotFoundException e) {
                throw new AddressNotFoundRuntimeException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        Country country = response.getCountry();
        City city = response.getCity();
        Location location = response.getLocation();
        Continent continent = response.getContinent();
        Subdivision subdivision = response.getMostSpecificSubdivision();
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        for (Property property : this.properties) {
            switch (property) {
                case IP: {
                    geoData.put("ip", NetworkAddress.format((InetAddress)ipAddress));
                    break;
                }
                case COUNTRY_ISO_CODE: {
                    geoData.put("country_iso_code", country.getIsoCode());
                    break;
                }
                case COUNTRY_NAME: {
                    geoData.put("country_name", country.getName());
                    break;
                }
                case CONTINENT_NAME: {
                    geoData.put("continent_name", continent.getName());
                    break;
                }
                case REGION_NAME: {
                    geoData.put("region_name", subdivision.getName());
                    break;
                }
                case CITY_NAME: {
                    geoData.put("city_name", city.getName());
                    break;
                }
                case TIMEZONE: {
                    geoData.put("timezone", location.getTimeZone());
                    break;
                }
                case LOCATION: {
                    HashMap<String, Double> locationObject = new HashMap<String, Double>();
                    locationObject.put("lat", location.getLatitude());
                    locationObject.put("lon", location.getLongitude());
                    geoData.put("location", locationObject);
                }
            }
        }
        return geoData;
    }

    private Map<String, Object> retrieveCountryGeoData(InetAddress ipAddress) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        CountryResponse response = AccessController.doPrivileged(() -> {
            try {
                return this.dbReader.country(ipAddress);
            }
            catch (AddressNotFoundException e) {
                throw new AddressNotFoundRuntimeException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        Country country = response.getCountry();
        Continent continent = response.getContinent();
        HashMap<String, Object> geoData = new HashMap<String, Object>();
        for (Property property : this.properties) {
            switch (property) {
                case IP: {
                    geoData.put("ip", NetworkAddress.format((InetAddress)ipAddress));
                    break;
                }
                case COUNTRY_ISO_CODE: {
                    geoData.put("country_iso_code", country.getIsoCode());
                    break;
                }
                case COUNTRY_NAME: {
                    geoData.put("country_name", country.getName());
                    break;
                }
                case CONTINENT_NAME: {
                    geoData.put("continent_name", continent.getName());
                }
            }
        }
        return geoData;
    }

    static enum Property {
        IP,
        COUNTRY_ISO_CODE,
        COUNTRY_NAME,
        CONTINENT_NAME,
        REGION_NAME,
        CITY_NAME,
        TIMEZONE,
        LOCATION;

        static final EnumSet<Property> ALL_CITY_PROPERTIES;
        static final EnumSet<Property> ALL_COUNTRY_PROPERTIES;

        public static Property parseProperty(String databaseType, String value) {
            EnumSet<Property> validProperties = EnumSet.noneOf(Property.class);
            if (GeoIpProcessor.CITY_DB_TYPE.equals(databaseType)) {
                validProperties = ALL_CITY_PROPERTIES;
            } else if (GeoIpProcessor.COUNTRY_DB_TYPE.equals(databaseType)) {
                validProperties = ALL_COUNTRY_PROPERTIES;
            }
            try {
                Property property = Property.valueOf(value.toUpperCase(Locale.ROOT));
                if (!validProperties.contains((Object)property)) {
                    throw new IllegalArgumentException("invalid");
                }
                return property;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("illegal property value [" + value + "]. valid values are " + Arrays.toString(validProperties.toArray()));
            }
        }

        static {
            ALL_CITY_PROPERTIES = EnumSet.allOf(Property.class);
            ALL_COUNTRY_PROPERTIES = EnumSet.of(IP, CONTINENT_NAME, COUNTRY_NAME, COUNTRY_ISO_CODE);
        }
    }

    private static final class AddressNotFoundRuntimeException
    extends RuntimeException {
        public AddressNotFoundRuntimeException(Throwable cause) {
            super(cause);
        }
    }

    public static final class Factory
    implements Processor.Factory {
        static final Set<Property> DEFAULT_CITY_PROPERTIES = EnumSet.of(Property.CONTINENT_NAME, Property.COUNTRY_ISO_CODE, Property.REGION_NAME, Property.CITY_NAME, Property.LOCATION);
        static final Set<Property> DEFAULT_COUNTRY_PROPERTIES = EnumSet.of(Property.CONTINENT_NAME, Property.COUNTRY_ISO_CODE);
        private final Map<String, DatabaseReader> databaseReaders;

        public Factory(Map<String, DatabaseReader> databaseReaders) {
            this.databaseReaders = databaseReaders;
        }

        public GeoIpProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            Set<Property> properties;
            String ipField = ConfigurationUtils.readStringProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"field");
            String targetField = ConfigurationUtils.readStringProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"target_field", (String)GeoIpProcessor.TYPE);
            String databaseFile = ConfigurationUtils.readStringProperty((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"database_file", (String)"GeoLite2-City.mmdb.gz");
            List propertyNames = ConfigurationUtils.readOptionalList((String)GeoIpProcessor.TYPE, (String)processorTag, config, (String)"properties");
            DatabaseReader databaseReader = this.databaseReaders.get(databaseFile);
            if (databaseReader == null) {
                throw ConfigurationUtils.newConfigurationException((String)GeoIpProcessor.TYPE, (String)processorTag, (String)"database_file", (String)("database file [" + databaseFile + "] doesn't exist"));
            }
            String databaseType = databaseReader.getMetadata().getDatabaseType();
            if (propertyNames != null) {
                properties = EnumSet.noneOf(Property.class);
                for (String fieldName : propertyNames) {
                    try {
                        properties.add(Property.parseProperty(databaseType, fieldName));
                    }
                    catch (IllegalArgumentException e) {
                        throw ConfigurationUtils.newConfigurationException((String)GeoIpProcessor.TYPE, (String)processorTag, (String)"properties", (String)e.getMessage());
                    }
                }
            } else if (GeoIpProcessor.CITY_DB_TYPE.equals(databaseType)) {
                properties = DEFAULT_CITY_PROPERTIES;
            } else if (GeoIpProcessor.COUNTRY_DB_TYPE.equals(databaseType)) {
                properties = DEFAULT_COUNTRY_PROPERTIES;
            } else {
                throw ConfigurationUtils.newConfigurationException((String)GeoIpProcessor.TYPE, (String)processorTag, (String)"database_file", (String)("Unsupported database type [" + databaseType + "]"));
            }
            return new GeoIpProcessor(processorTag, ipField, databaseReader, targetField, properties);
        }
    }
}

