/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tdigest;

import java.util.Collection;
import java.util.Locale;
import org.elasticsearch.tdigest.AVLTreeDigest;
import org.elasticsearch.tdigest.Centroid;
import org.elasticsearch.tdigest.HybridDigest;
import org.elasticsearch.tdigest.MergingDigest;
import org.elasticsearch.tdigest.ScaleFunction;
import org.elasticsearch.tdigest.SortingDigest;

public abstract class TDigest {
    protected ScaleFunction scale = ScaleFunction.K_2;
    double min = Double.POSITIVE_INFINITY;
    double max = Double.NEGATIVE_INFINITY;

    public static TDigest createMergingDigest(double compression) {
        return new MergingDigest(compression);
    }

    public static TDigest createAvlTreeDigest(double compression) {
        return new AVLTreeDigest(compression);
    }

    public static TDigest createSortingDigest() {
        return new SortingDigest();
    }

    public static TDigest createHybridDigest(double compression) {
        return new HybridDigest(compression);
    }

    public abstract void add(double var1, long var3);

    public final void add(double x) {
        this.add(x, 1L);
    }

    final void checkValue(double x) {
        if (Double.isNaN(x) || Double.isInfinite(x)) {
            throw new IllegalArgumentException("Invalid value: " + x);
        }
    }

    public abstract void compress();

    public abstract long size();

    public abstract double cdf(double var1);

    public abstract double quantile(double var1);

    public abstract Collection<Centroid> centroids();

    public abstract double compression();

    public abstract int byteSize();

    public void setScaleFunction(ScaleFunction scaleFunction) {
        if (scaleFunction.toString().endsWith("NO_NORM")) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Can't use %s as scale with %s", new Object[]{scaleFunction, this.getClass()}));
        }
        this.scale = scaleFunction;
    }

    public abstract void add(TDigest var1);

    public abstract int centroidCount();

    public void reserve(long size) {
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }
}

