/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.ssl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.UnrecoverableKeyException;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.common.ssl.SslConfigException;
import org.elasticsearch.entitlement.runtime.api.NotEntitledException;

final class SslFileUtil {
    SslFileUtil() {
    }

    static String pathsToString(List<Path> paths) {
        return paths.stream().map(Path::toAbsolutePath).map(Object::toString).collect(Collectors.joining(","));
    }

    static SslConfigException ioException(String fileType, List<Path> paths, IOException cause) {
        return SslFileUtil.ioException(fileType, paths, cause, null);
    }

    static SslConfigException ioException(String fileType, List<Path> paths, IOException cause, String detail) {
        if (cause instanceof FileNotFoundException || cause instanceof NoSuchFileException) {
            return SslFileUtil.fileNotFound(fileType, paths, cause);
        }
        if (cause instanceof AccessDeniedException) {
            return SslFileUtil.accessDenied(fileType, paths, (AccessDeniedException)cause);
        }
        String message = "cannot read configured " + fileType;
        if (!paths.isEmpty()) {
            message = message + " [" + SslFileUtil.pathsToString(paths) + "]";
        }
        if (SslFileUtil.hasCause(UnrecoverableKeyException.class, cause)) {
            message = message + " - this is usually caused by an incorrect password";
        } else if (cause != null && cause.getMessage() != null) {
            message = message + " - " + cause.getMessage();
        }
        if (detail != null) {
            message = message + "; " + detail;
        }
        return new SslConfigException(message, cause);
    }

    static SslConfigException fileNotFound(String fileType, List<Path> paths, IOException cause) {
        String message = "cannot read configured " + fileType + " [" + SslFileUtil.pathsToString(paths) + "] because ";
        message = paths.size() == 1 ? message + "the file does not exist" : message + "one or more files do not exist";
        return new SslConfigException(message, cause);
    }

    static SslConfigException accessDenied(String fileType, List<Path> paths, AccessDeniedException cause) {
        Object message = "not permitted to read ";
        message = paths.size() == 1 ? (String)message + "the " + fileType + " file" : (String)message + "one of more " + fileType + "files";
        message = (String)message + " [" + SslFileUtil.pathsToString(paths) + "]";
        return new SslConfigException((String)message, cause);
    }

    static SslConfigException notEntitledFailure(String fileType, List<Path> paths, NotEntitledException cause, Path basePath) {
        return SslFileUtil.innerAccessControlFailure(fileType, paths, (Exception)cause, basePath);
    }

    static SslConfigException accessControlFailure(String fileType, List<Path> paths, SecurityException cause, Path basePath) {
        return SslFileUtil.innerAccessControlFailure(fileType, paths, cause, basePath);
    }

    private static SslConfigException innerAccessControlFailure(String fileType, List<Path> paths, Exception cause, Path basePath) {
        String message = "cannot read configured " + fileType + " [" + SslFileUtil.pathsToString(paths) + "] because ";
        message = paths.size() == 1 ? message + "access to read the file is blocked" : message + "access to read one or more files is blocked";
        message = message + "; SSL resources should be placed in the ";
        message = basePath == null ? message + "Elasticsearch config directory" : message + "[" + basePath + "] directory";
        return new SslConfigException(message, cause);
    }

    public static SslConfigException securityException(String fileType, List<Path> paths, GeneralSecurityException cause) {
        return SslFileUtil.securityException(fileType, paths, cause, null);
    }

    public static SslConfigException securityException(String fileType, List<Path> paths, GeneralSecurityException cause, String detail) {
        String message = "cannot load " + fileType;
        if (!paths.isEmpty()) {
            message = message + " from [" + SslFileUtil.pathsToString(paths) + "]";
        }
        message = message + " due to " + cause.getClass().getSimpleName();
        if (cause.getMessage() != null) {
            message = message + " (" + cause.getMessage() + ")";
        }
        if (detail != null) {
            message = message + "; " + detail;
        } else if (SslFileUtil.hasCause(UnrecoverableKeyException.class, cause)) {
            message = message + "; this is usually caused by an incorrect password";
        }
        return new SslConfigException(message, cause);
    }

    private static boolean hasCause(Class<? extends Throwable> exceptionType, Throwable exception) {
        if (exception == null) {
            return false;
        }
        if (exceptionType.isInstance(exception)) {
            return true;
        }
        Throwable cause = exception.getCause();
        if (cause == null || cause == exception) {
            return false;
        }
        return SslFileUtil.hasCause(exceptionType, cause);
    }

    public static SslConfigException configException(String fileType, List<Path> paths, SslConfigException cause) {
        String message = "cannot load " + fileType;
        if (!paths.isEmpty()) {
            message = message + " from [" + SslFileUtil.pathsToString(paths) + "]";
        }
        message = message + " - " + cause.getMessage();
        return new SslConfigException(message, cause);
    }
}

