/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.hive;

import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.ql.metadata.DefaultStorageHandler;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.elasticsearch.hadoop.EsHadoopException;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.CompositeSettings;
import org.elasticsearch.hadoop.cfg.HadoopSettingsManager;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.hive.EsHiveInputFormat;
import org.elasticsearch.hadoop.hive.EsHiveOutputFormat;
import org.elasticsearch.hadoop.hive.EsSerDe;
import org.elasticsearch.hadoop.mr.EsOutputFormat;
import org.elasticsearch.hadoop.mr.HadoopCfgUtils;
import org.elasticsearch.hadoop.mr.security.HadoopUserProvider;
import org.elasticsearch.hadoop.mr.security.TokenUtil;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.rest.RestClient;
import org.elasticsearch.hadoop.security.User;
import org.elasticsearch.hadoop.security.UserProvider;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.ClusterInfo;

public class EsStorageHandler
extends DefaultStorageHandler {
    private static Log log = LogFactory.getLog(EsStorageHandler.class);

    public Class<? extends InputFormat> getInputFormatClass() {
        return EsHiveInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return EsHiveOutputFormat.class;
    }

    public Class<? extends SerDe> getSerDeClass() {
        return EsSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return null;
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.init(tableDesc, true);
        this.copyToJobProperties(jobProperties, tableDesc.getProperties());
        this.setUserProviderIfNotSet(jobProperties);
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.init(tableDesc, false);
        this.copyToJobProperties(jobProperties, tableDesc.getProperties());
        this.setUserProviderIfNotSet(jobProperties);
    }

    private void setUserProviderIfNotSet(Map<String, String> jobProperties) {
        String key = "es.security.user.provider.class";
        if (!jobProperties.containsKey(key)) {
            jobProperties.put(key, HadoopUserProvider.class.getName());
        }
    }

    private void init(TableDesc tableDesc, boolean read) {
        Configuration cfg = this.getConf();
        Settings settings = HadoopSettingsManager.loadFrom(cfg);
        if (!read) {
            HadoopCfgUtils.setOutputCommitterClass(cfg, EsOutputFormat.EsOutputCommitter.class.getName());
        }
        Assert.hasText(tableDesc.getProperties().getProperty("location"), String.format("no table location [%s] declared by Hive resulting in abnormal execution;", "location"));
    }

    private void copyToJobProperties(Map<String, String> jobProperties, Properties properties) {
        for (String key : properties.stringPropertyNames()) {
            if (!key.startsWith("es.") && !key.equals("location") && !key.equals("columns") && !key.equals("columns.types")) continue;
            jobProperties.put(key, properties.getProperty(key));
        }
    }

    @Deprecated
    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        throw new UnsupportedOperationException();
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Configuring job credentials for Elasticsearch");
        }
        CompositeSettings settings = new CompositeSettings(Arrays.asList(HadoopSettingsManager.loadFrom(tableDesc.getProperties()), HadoopSettingsManager.loadFrom(jobConf)));
        InitializationUtils.setUserProviderIfNotSet(settings, HadoopUserProvider.class, log);
        UserProvider userProvider = UserProvider.create(settings);
        if (userProvider.isEsKerberosEnabled()) {
            User user = userProvider.getUser();
            ClusterInfo clusterInfo = settings.getClusterInfoOrNull();
            RestClient bootstrap = new RestClient(settings);
            try {
                if (clusterInfo == null) {
                    clusterInfo = bootstrap.mainInfo();
                }
                TokenUtil.addTokenForJobConf(bootstrap, clusterInfo.getClusterName(), user, jobConf);
            }
            catch (EsHadoopException ex) {
                throw new EsHadoopIllegalArgumentException(String.format("Cannot detect ES version - typically this happens if the network/Elasticsearch cluster is not accessible or when targeting a WAN/Cloud instance without the proper setting '%s'", "es.nodes.wan.only"), ex);
            }
            finally {
                bootstrap.close();
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Ignoring Elasticsearch credentials since Kerberos Auth is not enabled.");
        }
    }
}

