/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.util.BitSet;
import java.util.Collections;
import java.util.List;

public class BulkResponse {
    private final int httpStatus;
    private final int totalWrites;
    private final BitSet leftovers;
    private final List<String> errorExamples;

    static BulkResponse ok(int totalWrites) {
        return new BulkResponse(totalWrites);
    }

    private BulkResponse(int totalWrites) {
        this(200, totalWrites, new BitSet(), Collections.emptyList());
    }

    public BulkResponse(int httpStatus, int totalWrites, BitSet leftovers, List<String> errorExamples) {
        this.httpStatus = httpStatus;
        this.totalWrites = totalWrites;
        this.leftovers = leftovers;
        this.errorExamples = errorExamples;
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public int getTotalWrites() {
        return this.totalWrites;
    }

    public BitSet getLeftovers() {
        return this.leftovers;
    }

    public List<String> getErrorExamples() {
        return this.errorExamples;
    }
}

