/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.pig;

import java.util.List;
import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.pig.PigTuple;
import org.elasticsearch.hadoop.serialization.field.ConstantFieldExtractor;
import org.elasticsearch.hadoop.util.Assert;

public class PigFieldExtractor
extends ConstantFieldExtractor {
    @Override
    protected Object extractField(Object target) {
        List<String> fieldNames = this.getFieldNames();
        for (int index = 0; index < fieldNames.size(); ++index) {
            String fieldName = fieldNames.get(index);
            if (target instanceof PigTuple) {
                PigTuple pt = (PigTuple)target;
                ResourceSchema.ResourceFieldSchema[] fields = pt.getSchema().getSchema().getFields();
                boolean foundField = false;
                for (int i = 0; i < fields.length && !foundField; ++i) {
                    ResourceSchema.ResourceFieldSchema field = fields[i];
                    if (!fieldName.equals(field.getName())) continue;
                    foundField = true;
                    byte type = field.getType();
                    try {
                        Object object = pt.getTuple().get(i);
                        if (DataType.isAtomic((byte)type)) {
                            target = object.toString();
                            continue;
                        }
                        if (type == 110) {
                            PigTuple rpt = new PigTuple(field.getSchema());
                            if (object instanceof PigTuple) {
                                rpt.setTuple(((PigTuple)object).getTuple());
                            } else {
                                rpt.setTuple((Tuple)object);
                            }
                            target = rpt;
                            continue;
                        }
                        Assert.isTrue(false, String.format("Unsupported data type [%s] for field [%s]; use only 'primitives' or 'tuples'", DataType.findTypeName((byte)type), fieldName));
                        continue;
                    }
                    catch (ExecException ex) {
                        throw new EsHadoopIllegalStateException(String.format("Cannot retrieve field [%s]", fieldName), ex);
                    }
                }
                continue;
            }
            return NOT_FOUND;
        }
        return target;
    }
}

