/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.dto.NodeInfo;
import org.elasticsearch.hadoop.serialization.field.FieldFilter;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.hadoop.util.StringUtils;

public abstract class SettingsUtils {
    private static List<String> qualifyNodes(String nodes, int defaultPort, boolean resolveHostNames) {
        List<String> list = StringUtils.tokenize(nodes);
        for (int i = 0; i < list.size(); ++i) {
            String nodeIp = resolveHostNames ? SettingsUtils.resolveHostToIpIfNecessary(list.get(i)) : list.get(i);
            list.set(i, SettingsUtils.qualifyNode(nodeIp, defaultPort));
        }
        return list;
    }

    private static String qualifyNode(String node, int defaultPort) {
        int index = node.lastIndexOf(58);
        if (index > 0 && index + 1 < node.length() && Character.isDigit(node.charAt(index + 1))) {
            return node;
        }
        return node + ":" + defaultPort;
    }

    private static String resolveHostToIpIfNecessary(String host) {
        String port;
        int index;
        String schemaDelimiter = "://";
        String schema2 = "";
        if (host.contains(schemaDelimiter)) {
            index = host.indexOf(schemaDelimiter);
            schema2 = host.substring(0, index);
            host = host.substring(index + schemaDelimiter.length());
        }
        String name = (index = host.lastIndexOf(58)) > 0 ? host.substring(0, index) : host;
        String string = port = index > 0 ? host.substring(index) : "";
        if (StringUtils.hasLetter(name)) {
            try {
                String hostAddress = InetAddress.getByName(name).getHostAddress() + port;
                return StringUtils.hasText(schema2) ? schema2 + schemaDelimiter + hostAddress : hostAddress;
            }
            catch (UnknownHostException ex) {
                throw new EsHadoopIllegalArgumentException("Cannot resolve ip for hostname: " + name);
            }
        }
        return host;
    }

    public static void pinNode(Settings settings, String address) {
        settings.setProperty("es.internal.pinned.node", address);
    }

    public static boolean hasPinnedNode(Settings settings) {
        return StringUtils.hasText(settings.getProperty("es.internal.pinned.node"));
    }

    public static String getPinnedNode(Settings settings) {
        String node = settings.getProperty("es.internal.pinned.node");
        Assert.hasText(node, "Task has not been pinned to a node...");
        return node;
    }

    public static void addDiscoveredNodes(Settings settings, List<NodeInfo> discoveredNodes) {
        LinkedHashSet<String> nodes = new LinkedHashSet<String>();
        nodes.addAll(SettingsUtils.declaredNodes(settings));
        for (NodeInfo node : discoveredNodes) {
            if (!node.hasHttp()) continue;
            nodes.add(node.getPublishAddress());
        }
        SettingsUtils.setDiscoveredNodes(settings, nodes);
    }

    public static void setDiscoveredNodes(Settings settings, Collection<String> nodes) {
        settings.setProperty("es.internal.discovered.nodes", StringUtils.concatenate(nodes));
    }

    public static List<String> declaredNodes(Settings settings) {
        return SettingsUtils.qualifyNodes(settings.getNodes(), settings.getPort(), settings.getNodesResolveHostnames());
    }

    public static List<String> discoveredOrDeclaredNodes(Settings settings) {
        String discoveredNodes = settings.getProperty("es.internal.discovered.nodes");
        return StringUtils.hasText(discoveredNodes) ? StringUtils.tokenize(discoveredNodes) : SettingsUtils.declaredNodes(settings);
    }

    public static Map<String, String> aliases(String definition, boolean caseInsensitive) {
        List<String> aliases = StringUtils.tokenize(definition);
        LinkedHashMap<String, String> aliasMap = new LinkedHashMap<String, String>();
        if (aliases != null) {
            for (String string : aliases) {
                int index = (string = string.trim()).indexOf(":");
                if (index <= 0) continue;
                String key = string.substring(0, index);
                aliasMap.put(key, string.substring(index + 1));
                aliasMap.put(caseInsensitive ? key.toLowerCase(Locale.ROOT) : key, string.substring(index + 1));
            }
        }
        return aliasMap;
    }

    public static void setFilters(Settings settings, String ... filters) {
        settings.setProperty("es.internal.query.filters", "");
        if (ObjectUtils.isEmpty(filters)) {
            return;
        }
        settings.setProperty("es.internal.query.filters", IOUtils.serializeToBase64((Serializable)filters));
    }

    public static String[] getFilters(Settings settings) {
        return (String[])IOUtils.deserializeFromBase64(settings.getProperty("es.internal.query.filters"));
    }

    public static boolean isEs50(Settings settings) {
        String version = settings.getProperty("es.internal.es.version");
        if (!StringUtils.hasText(version)) {
            return true;
        }
        return version.startsWith("5.0");
    }

    public static List<FieldFilter.NumberedInclude> getFieldArrayFilterInclude(Settings settings) {
        String includeString = settings.getReadFieldAsArrayInclude();
        List<String> includes = StringUtils.tokenize(includeString);
        ArrayList<FieldFilter.NumberedInclude> list = new ArrayList<FieldFilter.NumberedInclude>(includes.size());
        for (String include : includes) {
            int index = include.indexOf(":");
            String filter = include;
            int depth = 1;
            try {
                if (index > 0) {
                    filter = include.substring(0, index);
                    String depthString = include.substring(index + 1);
                    if (depthString.length() > 0) {
                        depth = Integer.parseInt(depthString);
                    }
                }
            }
            catch (NumberFormatException ex) {
                throw new EsHadoopIllegalArgumentException(String.format(Locale.ROOT, "Invalid parameter [%s] specified in setting [%s]", include, includeString), ex);
            }
            list.add(new FieldFilter.NumberedInclude(filter, depth));
        }
        return list;
    }

    public static String getFixedRouting(Settings settings) {
        String routing = settings.getMappingRouting();
        if (StringUtils.hasText(routing) && (routing = routing.trim()).startsWith("<") && routing.endsWith(">")) {
            return routing.substring(1, routing.length() - 1);
        }
        return null;
    }
}

