/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.pooling;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.TransportFactory;
import org.elasticsearch.hadoop.rest.pooling.PooledHttpTransportFactory;

public final class PooledTransportManager {
    private static final Log LOG = LogFactory.getLog(PooledTransportManager.class);
    private static final ConcurrentMap<String, PooledHttpTransportFactory> poolRegistry = new ConcurrentHashMap<String, PooledHttpTransportFactory>();

    private PooledTransportManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TransportFactory getTransportFactory(Settings jobSettings) {
        String jobKey = jobSettings.getProperty("es.internal.transport.pooling.key");
        PooledHttpTransportFactory factoryForJob = (PooledHttpTransportFactory)poolRegistry.get(jobKey);
        if (factoryForJob != null) return factoryForJob;
        Class<PooledTransportManager> clazz = PooledTransportManager.class;
        synchronized (PooledTransportManager.class) {
            factoryForJob = (PooledHttpTransportFactory)poolRegistry.get(jobKey);
            if (factoryForJob != null) return factoryForJob;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating new PooledTransportFactory for job key [" + jobKey + "]"));
            }
            factoryForJob = new PooledHttpTransportFactory(jobKey);
            poolRegistry.put(jobKey, factoryForJob);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return factoryForJob;
        }
    }
}

