/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.yarn.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.elasticsearch.hadoop.yarn.cfg.Config;
import org.elasticsearch.hadoop.yarn.util.IOUtils;

public class HttpDownloader {
    private boolean useTimestamp = false;
    private boolean skipExisting = false;

    public HttpDownloader() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean downloadES(Config cfg) {
        return this.download(cfg.downloadURL(), cfg.downloadedEs(), new VerboseProgress(System.out), TimeUnit.MINUTES.toMillis(15L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean download(URL source, File dest, DownloadProgress progress, long timeout) {
        if (dest.exists() && this.skipExisting) {
            return true;
        }
        if (progress == null) {
            progress = new NullProgress();
        }
        long timestamp = 0L;
        boolean hasTimestamp = false;
        if (this.useTimestamp && dest.exists()) {
            timestamp = dest.lastModified();
            hasTimestamp = true;
        }
        if (!dest.exists()) {
            try {
                File parent = dest.getAbsoluteFile().getParentFile();
                parent.mkdirs();
                dest.createNewFile();
            }
            catch (IOException ex) {
                throw new IllegalStateException(String.format("Cannot write file %s", dest), ex);
            }
        }
        GetThread getThread = new GetThread(source, dest, hasTimestamp, timestamp, progress);
        try {
            getThread.setDaemon(true);
            getThread.start();
            getThread.join(timeout);
            if (getThread.isAlive()) {
                throw new IllegalStateException("The GET operation took longer than " + timeout + ", stopping it.");
            }
        }
        catch (InterruptedException ie) {
            boolean bl = false;
            return bl;
        }
        finally {
            getThread.closeStreams();
        }
        return getThread.wasSuccessful();
    }

    private class GetThread
    extends Thread {
        private final URL source;
        private final File dest;
        private final boolean hasTimestamp;
        private final long timestamp;
        private final DownloadProgress progress;
        private boolean success = false;
        private RuntimeException ioexception = null;
        private InputStream is = null;
        private OutputStream os = null;
        private URLConnection connection;
        private int redirections = 0;

        GetThread(URL source, File dest, boolean h, long t, DownloadProgress p) {
            this.source = source;
            this.dest = dest;
            this.hasTimestamp = h;
            this.timestamp = t;
            this.progress = p;
        }

        @Override
        public void run() {
            try {
                this.success = this.get();
            }
            catch (IOException ioex) {
                this.ioexception = new IllegalStateException(ioex);
            }
        }

        private boolean get() throws IOException {
            this.connection = this.openConnection(this.source);
            if (this.connection == null) {
                return false;
            }
            boolean downloadSucceeded = this.downloadFile();
            if (downloadSucceeded && HttpDownloader.this.useTimestamp) {
                this.updateTimeStamp();
            }
            return downloadSucceeded;
        }

        private boolean redirectionAllowed(URL aSource, URL aDest) throws IOException {
            ++this.redirections;
            if (this.redirections > 5) {
                String message = "More than 5 times redirected, giving up";
                throw new IOException(message);
            }
            return true;
        }

        private URLConnection openConnection(URL aSource) throws IOException {
            URLConnection connection = aSource.openConnection();
            if (this.hasTimestamp) {
                connection.setIfModifiedSince(this.timestamp);
            }
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).setInstanceFollowRedirects(false);
                ((HttpURLConnection)connection).setUseCaches(true);
                ((HttpURLConnection)connection).setConnectTimeout(5000);
            }
            connection.connect();
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                int responseCode = httpConnection.getResponseCode();
                if (responseCode == 301 || responseCode == 302 || responseCode == 303) {
                    String newLocation = httpConnection.getHeaderField("Location");
                    String message = aSource + (responseCode == 301 ? " permanently" : "") + " moved to " + newLocation;
                    URL newURL = new URL(newLocation);
                    if (!this.redirectionAllowed(aSource, newURL)) {
                        return null;
                    }
                    return this.openConnection(newURL);
                }
                long lastModified = httpConnection.getLastModified();
                if (responseCode == 304 || lastModified != 0L && this.hasTimestamp && this.timestamp >= lastModified) {
                    return null;
                }
                if (responseCode == 401) {
                    String message = "HTTP Authorization failure";
                    throw new IOException(message);
                }
            }
            return connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean downloadFile() throws FileNotFoundException, IOException {
            IOException lastEx = null;
            for (int i = 0; i < 3; ++i) {
                try {
                    this.is = this.connection.getInputStream();
                    break;
                }
                catch (IOException ex) {
                    lastEx = ex;
                    continue;
                }
            }
            if (this.is == null) {
                throw new IOException("Can't get " + this.source + " to " + this.dest, lastEx);
            }
            this.os = new FileOutputStream(this.dest);
            this.progress.beginDownload();
            boolean finished = false;
            try {
                int length;
                byte[] buffer = new byte[524288];
                while (!this.isInterrupted() && (length = this.is.read(buffer)) >= 0) {
                    this.os.write(buffer, 0, length);
                    this.progress.onTick();
                }
                finished = !this.isInterrupted();
            }
            finally {
                if (!finished) {
                    IOUtils.close(this.os);
                    IOUtils.close(this.is);
                    this.dest.delete();
                } else {
                    IOUtils.close(this.os);
                    IOUtils.close(this.is);
                }
            }
            this.progress.endDownload();
            return true;
        }

        private void updateTimeStamp() {
            long remoteTimestamp = this.connection.getLastModified();
            if (remoteTimestamp != 0L) {
                this.dest.setLastModified(remoteTimestamp);
            }
        }

        boolean wasSuccessful() {
            if (this.ioexception != null) {
                throw this.ioexception;
            }
            return this.success;
        }

        void closeStreams() {
            this.interrupt();
            if (this.success) {
                IOUtils.close(this.is);
                IOUtils.close(this.os);
            } else {
                IOUtils.close(this.is);
                IOUtils.close(this.os);
                if (this.dest != null && this.dest.exists()) {
                    this.dest.delete();
                }
            }
        }
    }

    public static class VerboseProgress
    implements DownloadProgress {
        private int dots = 0;
        PrintStream out;

        public VerboseProgress(PrintStream out) {
            this.out = out;
        }

        @Override
        public void beginDownload() {
            this.out.print("Downloading ");
            this.dots = 0;
        }

        @Override
        public void onTick() {
            this.out.print(".");
            if (this.dots++ > 50) {
                this.out.flush();
                this.dots = 0;
            }
        }

        @Override
        public void endDownload() {
            this.out.println("DONE");
            this.out.flush();
        }
    }

    public static class NullProgress
    implements DownloadProgress {
        @Override
        public void beginDownload() {
        }

        @Override
        public void onTick() {
        }

        @Override
        public void endDownload() {
        }
    }

    public static interface DownloadProgress {
        public void beginDownload();

        public void onTick();

        public void endDownload();
    }
}

