/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.yarn.am;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.client.api.NMTokenCache;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.elasticsearch.hadoop.yarn.am.EsYarnNmException;
import org.elasticsearch.hadoop.yarn.compat.YarnCompat;

class NodeMasterRpc
implements AutoCloseable {
    private final Configuration cfg;
    private final NMTokenCache tokenCache;
    private NMClient client;

    public NodeMasterRpc(Configuration cfg, NMTokenCache tokenCache) {
        this.cfg = new YarnConfiguration(cfg);
        this.tokenCache = tokenCache;
    }

    public void start() {
        if (this.client != null) {
            return;
        }
        this.client = NMClient.createNMClient((String)"Elasticsearch-YARN");
        YarnCompat.setNMTokenCache(this.client, this.tokenCache);
        this.client.init(this.cfg);
        this.client.start();
    }

    public Map<String, ByteBuffer> startContainer(Container container, ContainerLaunchContext containerLaunchContext) {
        try {
            return this.client.startContainer(container, containerLaunchContext);
        }
        catch (Exception ex) {
            throw new EsYarnNmException();
        }
    }

    public ContainerStatus getContainerState(ContainerId containerId, NodeId nodeId) {
        try {
            return this.client.getContainerStatus(containerId, nodeId);
        }
        catch (Exception ex) {
            throw new EsYarnNmException();
        }
    }

    @Override
    public void close() {
        if (this.client == null) {
            return;
        }
        this.client.stop();
        this.client = null;
    }
}

