/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.ErrorUtils;
import org.elasticsearch.hadoop.rest.EsHadoopInvalidRequest;
import org.elasticsearch.hadoop.rest.EsHadoopParsingException;
import org.elasticsearch.hadoop.rest.HttpRetryPolicy;
import org.elasticsearch.hadoop.rest.HttpStatus;
import org.elasticsearch.hadoop.rest.NetworkClient;
import org.elasticsearch.hadoop.rest.NoHttpRetryPolicy;
import org.elasticsearch.hadoop.rest.Request;
import org.elasticsearch.hadoop.rest.Resource;
import org.elasticsearch.hadoop.rest.Response;
import org.elasticsearch.hadoop.rest.Retry;
import org.elasticsearch.hadoop.rest.SimpleHttpRetryPolicy;
import org.elasticsearch.hadoop.rest.SimpleRequest;
import org.elasticsearch.hadoop.rest.stats.Stats;
import org.elasticsearch.hadoop.rest.stats.StatsAware;
import org.elasticsearch.hadoop.serialization.Parser;
import org.elasticsearch.hadoop.serialization.ParsingUtils;
import org.elasticsearch.hadoop.serialization.dto.Node;
import org.elasticsearch.hadoop.serialization.json.JacksonJsonParser;
import org.elasticsearch.hadoop.serialization.json.JsonFactory;
import org.elasticsearch.hadoop.serialization.json.ObjectReader;
import org.elasticsearch.hadoop.util.ByteSequence;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.hadoop.util.SettingsUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.TrackingBytesArray;
import org.elasticsearch.hadoop.util.unit.TimeValue;

public class RestClient
implements Closeable,
StatsAware {
    private NetworkClient network;
    private final ObjectMapper mapper = new ObjectMapper();
    private final TimeValue scrollKeepAlive;
    private final boolean indexReadMissingAsEmpty;
    private final HttpRetryPolicy retryPolicy;
    private final boolean isES1x;
    private final boolean isES20;
    private final boolean isES50;
    private final Stats stats;

    public RestClient(Settings settings) {
        this.mapper.configure(DeserializationConfig.Feature.USE_ANNOTATIONS, false);
        this.mapper.configure(SerializationConfig.Feature.USE_ANNOTATIONS, false);
        this.stats = new Stats();
        this.network = new NetworkClient(settings);
        this.scrollKeepAlive = TimeValue.timeValueMillis(settings.getScrollKeepAlive());
        this.indexReadMissingAsEmpty = settings.getIndexReadMissingAsEmpty();
        String retryPolicyName = settings.getBatchWriteRetryPolicy();
        if ("simple".equals(retryPolicyName)) {
            retryPolicyName = SimpleHttpRetryPolicy.class.getName();
        } else if ("none".equals(retryPolicyName)) {
            retryPolicyName = NoHttpRetryPolicy.class.getName();
        }
        this.retryPolicy = (HttpRetryPolicy)ObjectUtils.instantiate(retryPolicyName, settings);
        this.isES1x = SettingsUtils.isEs1x(settings);
        this.isES20 = SettingsUtils.isEs20(settings);
        this.isES50 = SettingsUtils.isEs50(settings);
    }

    public List<String> discoverNodes() {
        String endpoint = "_nodes/transport";
        Map nodes = (Map)this.get(endpoint, "nodes");
        ArrayList<String> hosts = new ArrayList<String>(nodes.size());
        for (Map value : nodes.values()) {
            String inet = (String)value.get("http_address");
            if (!StringUtils.hasText(inet)) continue;
            hosts.add(StringUtils.parseIpAddress(inet).toString());
        }
        return hosts;
    }

    private <T> T get(String q, String string) {
        return this.parseContent(this.execute(Request.Method.GET, q), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T parseContent(InputStream content, String string) {
        Map map = Collections.emptyMap();
        try {
            JsonParser jsonParser = this.mapper.getJsonFactory().createJsonParser(content);
            try {
                map = (Map)this.mapper.readValue(jsonParser, Map.class);
            }
            finally {
                this.countStreamStats(content);
            }
        }
        catch (IOException ex) {
            throw new EsHadoopParsingException(ex);
        }
        return (T)(string != null ? map.get(string) : map);
    }

    public BitSet bulk(Resource resource, TrackingBytesArray data) {
        Retry retry = this.retryPolicy.init();
        int httpStatus = 0;
        boolean isRetry = false;
        do {
            long start = this.network.transportStats().netTotalTime;
            Response response = this.execute(Request.Method.PUT, resource.bulk(), data);
            long spent = this.network.transportStats().netTotalTime - start;
            ++this.stats.bulkTotal;
            this.stats.docsSent += (long)data.entries();
            this.stats.bulkTotalTime += spent;
            if (isRetry) {
                this.stats.docsRetried += (long)data.entries();
                this.stats.bytesRetried += (long)data.length();
                ++this.stats.bulkRetries;
                this.stats.bulkRetriesTotalTime += spent;
            }
            isRetry = true;
            int n = httpStatus = this.retryFailedEntries(response, data) ? 503 : 200;
        } while (data.length() > 0 && retry.retry(httpStatus));
        return data.leftoversPosition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean retryFailedEntries(Response response, TrackingBytesArray data) {
        InputStream content = response.body();
        try {
            ObjectReader r = JsonFactory.objectReader(this.mapper, Map.class);
            JsonParser parser = this.mapper.getJsonFactory().createJsonParser(content);
            try {
                if (ParsingUtils.seek((Parser)new JacksonJsonParser(parser), "items") == null) {
                    this.stats.bytesAccepted += (long)data.length();
                    this.stats.docsAccepted += (long)data.entries();
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.countStreamStats(content);
            }
            int entryToDeletePosition = 0;
            Iterator iterator = r.readValues(parser);
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                Map values2 = (Map)map.values().iterator().next();
                Integer status = (Integer)values2.get("status");
                String error = this.extractError(values2);
                if (error != null) {
                    if (status != null && HttpStatus.canRetry(status) || error.contains("EsRejectedExecutionException")) {
                        ++entryToDeletePosition;
                        continue;
                    }
                    String message = status != null ? String.format("[%s] returned %s(%s) - %s", response.uri(), HttpStatus.getText(status), status, this.prettify(error)) : this.prettify(error);
                    throw new EsHadoopInvalidRequest(String.format("Found unrecoverable error %s; Bailing out..", message));
                }
                this.stats.bytesAccepted += (long)data.length(entryToDeletePosition);
                ++this.stats.docsAccepted;
                data.remove(entryToDeletePosition);
            }
            if (entryToDeletePosition <= 0) return false;
            return true;
        }
        catch (IOException ex) {
            throw new EsHadoopParsingException(ex);
        }
    }

    private String extractError(Map jsonMap) {
        Object err = jsonMap.get("error");
        String error = null;
        if (err != null) {
            if (err instanceof Map) {
                Map m = (Map)err;
                if ((err = m.get("root_cause")) == null) {
                    error = m.get("reason").toString();
                    if (m.containsKey("caused_by")) {
                        error = error + ";" + ((Map)m.get("caused_by")).get("reason");
                    }
                } else {
                    Map nestedM;
                    Object nested;
                    error = err instanceof List ? ((nested = ((List)err).get(0)) instanceof Map ? ((nestedM = (Map)nested).containsKey("reason") ? nestedM.get("reason").toString() : nested.toString()) : nested.toString()) : err.toString();
                }
            } else {
                error = err.toString();
            }
        }
        return error;
    }

    private String prettify(String error) {
        if (this.isES20) {
            return error;
        }
        String invalidFragment = ErrorUtils.extractInvalidXContent(error);
        String header = invalidFragment != null ? "Invalid JSON fragment received[" + invalidFragment + "]" : "";
        return header + "[" + error + "]";
    }

    private String prettify(String error, ByteSequence body) {
        if (this.isES20) {
            return error;
        }
        String message = ErrorUtils.extractJsonParse(error, body);
        return message != null ? error + "; fragment[" + message + "]" : error;
    }

    public void refresh(Resource resource) {
        this.execute(Request.Method.POST, resource.refresh());
    }

    public List<List<Map<String, Object>>> targetShards(String index, String routing) {
        SimpleRequest req;
        Response res;
        List shardsJson = null;
        String target = index + "/_search_shards";
        if (routing != null) {
            target = target + "?routing=" + StringUtils.encodeQuery(routing);
        }
        shardsJson = this.indexReadMissingAsEmpty ? ((res = this.executeNotFoundAllowed(req = new SimpleRequest(Request.Method.GET, null, target))).status() == 200 ? (List)this.parseContent(res.body(), "shards") : Collections.emptyList()) : (List)this.get(target, "shards");
        return shardsJson;
    }

    public Map<String, Node> getHttpNodes(boolean allowNonHttp) {
        Map nodesData = (Map)this.get("_nodes/http", "nodes");
        LinkedHashMap<String, Node> nodes = new LinkedHashMap<String, Node>();
        for (Map.Entry entry : nodesData.entrySet()) {
            Node node = new Node((String)entry.getKey(), (Map)entry.getValue());
            if (!allowNonHttp && (!node.hasHttp() || node.isClient())) continue;
            nodes.put((String)entry.getKey(), node);
        }
        return nodes;
    }

    public List<String> getHttpClientNodes() {
        Map nodesData = (Map)this.get("_nodes/http", "nodes");
        ArrayList<String> nodes = new ArrayList<String>();
        for (Map.Entry entry : nodesData.entrySet()) {
            Node node = new Node((String)entry.getKey(), (Map)entry.getValue());
            if (!node.isClient() || !node.hasHttp()) continue;
            nodes.add(node.getInet());
        }
        return nodes;
    }

    public List<String> getHttpDataNodes() {
        Map nodesData = (Map)this.get("_nodes/http", "nodes");
        ArrayList<String> nodes = new ArrayList<String>();
        for (Map.Entry entry : nodesData.entrySet()) {
            Node node = new Node((String)entry.getKey(), (Map)entry.getValue());
            if (!node.isData() || !node.hasHttp()) continue;
            nodes.add(node.getInet());
        }
        return nodes;
    }

    public Map<String, Object> getMapping(String query) {
        return (Map)this.get(query, null);
    }

    public Map<String, Object> sampleForFields(String indexAndType, Collection<String> fields) {
        if (fields == null || fields.isEmpty()) {
            return Collections.emptyMap();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{ \"terminate_after\":1, \"size\":1,\n");
        sb.append("\"_source\": [");
        for (String field : fields) {
            sb.append(String.format(Locale.ROOT, "\"%s\",", field));
        }
        sb.setLength(sb.length() - 1);
        sb.append("],\n\"query\":{");
        if (!this.isES1x) {
            sb.append("\"bool\": { \"must\":[");
        } else {
            sb.append("\"constant_score\":{ \"filter\": { \"and\":[");
        }
        for (String field : fields) {
            sb.append(String.format(Locale.ROOT, "\n{ \"exists\":{ \"field\":\"%s\"} },", field));
        }
        sb.setLength(sb.length() - 1);
        sb.append("\n]}");
        if (!this.isES20) {
            sb.append("}");
        }
        sb.append("}}");
        Map hits = (Map)this.parseContent(this.execute(Request.Method.GET, indexAndType + "/_search", new BytesArray(sb.toString())).body(), "hits");
        List docs = (List)hits.get("hits");
        if (docs == null || docs.isEmpty()) {
            return Collections.emptyMap();
        }
        Map foundFields = (Map)docs.get(0);
        Map fieldInfo = (Map)foundFields.get("_source");
        return fieldInfo;
    }

    @Override
    public void close() {
        if (this.network != null) {
            this.network.close();
            this.stats.aggregate(this.network.stats());
            this.network = null;
        }
    }

    protected InputStream execute(Request request) {
        return this.execute(request, true).body();
    }

    protected InputStream execute(Request.Method method, String path) {
        return this.execute(new SimpleRequest(method, null, path));
    }

    protected Response execute(Request.Method method, String path, boolean checkStatus) {
        return this.execute(new SimpleRequest(method, null, path), checkStatus);
    }

    protected Response execute(Request.Method method, String path, ByteSequence buffer) {
        return this.execute(new SimpleRequest(method, null, path, null, buffer), true);
    }

    protected Response execute(Request.Method method, String path, ByteSequence buffer, boolean checkStatus) {
        return this.execute(new SimpleRequest(method, null, path, null, buffer), checkStatus);
    }

    protected Response execute(Request request, boolean checkStatus) {
        Response response = this.network.execute(request);
        if (checkStatus) {
            this.checkResponse(request, response);
        }
        return response;
    }

    protected Response executeNotFoundAllowed(Request req) {
        Response res = this.execute(req, false);
        switch (res.status()) {
            case 200: {
                break;
            }
            case 404: {
                break;
            }
            default: {
                this.checkResponse(req, res);
            }
        }
        return res;
    }

    private void checkResponse(Request request, Response response) {
        if (response.hasFailed()) {
            String msg = null;
            try {
                msg = this.extractError((Map)this.parseContent(response.body(), null));
                msg = response.isClientError() ? msg + "\n" + request.body() : this.prettify(msg, request.body());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!StringUtils.hasText(msg)) {
                msg = String.format("[%s] on [%s] failed; server[%s] returned [%s|%s:%s]", request.method().name(), request.path(), response.uri(), response.status(), response.statusDescription(), IOUtils.asStringAlways(response.body()));
            }
            throw new EsHadoopInvalidRequest(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream scroll(String scrollId) {
        long start = this.network.transportStats().netTotalTime;
        try {
            InputStream is = this.execute(Request.Method.POST, "_search/scroll?scroll=" + this.scrollKeepAlive.toString(), new BytesArray(scrollId)).body();
            ++this.stats.scrollTotal;
            InputStream inputStream = is;
            return inputStream;
        }
        finally {
            this.stats.scrollTotalTime += this.network.transportStats().netTotalTime - start;
        }
    }

    public boolean delete(String indexOrType) {
        SimpleRequest req = new SimpleRequest(Request.Method.DELETE, null, indexOrType);
        Response res = this.executeNotFoundAllowed(req);
        return res.status() == 200;
    }

    public boolean deleteScroll(String scrollId) {
        SimpleRequest req = new SimpleRequest(Request.Method.DELETE, null, (CharSequence)"_search/scroll", new BytesArray(scrollId.getBytes(StringUtils.UTF_8)));
        Response res = this.executeNotFoundAllowed(req);
        return res.status() == 200;
    }

    public boolean exists(String indexOrType) {
        SimpleRequest req = new SimpleRequest(Request.Method.HEAD, null, indexOrType);
        Response res = this.executeNotFoundAllowed(req);
        return res.status() == 200;
    }

    public boolean touch(String indexOrType) {
        if (!this.exists(indexOrType)) {
            Response response = this.execute(Request.Method.PUT, indexOrType, false);
            if (response.hasFailed()) {
                String msg = null;
                try {
                    msg = (String)this.parseContent(response.body(), "error");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (StringUtils.hasText(msg) && !msg.contains("IndexAlreadyExistsException")) {
                    throw new EsHadoopIllegalStateException(msg);
                }
            }
            return response.hasSucceeded();
        }
        return false;
    }

    public long count(String indexAndType, ByteSequence query) {
        return this.isES50 ? this.countInES5X(indexAndType, query) : this.countBeforeES5X(indexAndType, query);
    }

    private long countBeforeES5X(String indexAndType, ByteSequence query) {
        Response response = this.execute(Request.Method.GET, indexAndType + "/_count", query);
        Number count = (Number)this.parseContent(response.body(), "count");
        return count != null ? count.longValue() : -1L;
    }

    private long countInES5X(String indexAndType, ByteSequence query) {
        Response response = this.execute(Request.Method.GET, indexAndType + "/_search?size=0", query);
        Map content = (Map)this.parseContent(response.body(), "hits");
        Number count = (Number)content.get("total");
        return count != null ? count.longValue() : -1L;
    }

    public boolean isAlias(String query) {
        Map aliases = (Map)this.get(query, null);
        return aliases.size() > 1;
    }

    public void putMapping(String index, String mapping, byte[] bytes) {
        this.touch(index);
        this.execute(Request.Method.PUT, mapping, new BytesArray(bytes));
    }

    public String esVersion() {
        Map version = (Map)this.get("", "version");
        if (version == null || !StringUtils.hasText((CharSequence)version.get("number"))) {
            return "Unknown";
        }
        return (String)version.get("number");
    }

    public boolean health(String index, HEALTH health, TimeValue timeout) {
        StringBuilder sb = new StringBuilder("/_cluster/health/");
        sb.append(index);
        sb.append("?wait_for_status=");
        sb.append(health.name().toLowerCase(Locale.ROOT));
        sb.append("&timeout=");
        sb.append(timeout.toString());
        return Boolean.TRUE.equals(this.get(sb.toString(), "timed_out"));
    }

    @Override
    public Stats stats() {
        Stats copy = new Stats(this.stats);
        if (this.network != null) {
            copy.aggregate(this.network.stats());
        }
        return copy;
    }

    private void countStreamStats(InputStream content) {
        if (content instanceof StatsAware) {
            this.stats.aggregate(((StatsAware)((Object)content)).stats());
        }
    }

    public String getCurrentNode() {
        return this.network.currentNode();
    }

    public static enum HEALTH {
        RED,
        YELLOW,
        GREEN;

    }
}

