/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.Parser;
import org.elasticsearch.hadoop.serialization.ParsingUtils;
import org.elasticsearch.hadoop.serialization.json.JacksonJsonParser;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.FastByteArrayInputStream;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.StringUtils;

abstract class QueryUtils {
    private static String QUERY_STRING_QUERY = "{\"query\":{\"query_string\":{ %s }}}";
    static String MATCH_ALL = "{\"query\":{\"match_all\":{}}}";
    private static String QUOTE = "\"";
    private static Map<String, String> URI_QUERY_TO_DSL = new HashMap<String, String>();
    private static String PUSH_DOWN = "{\"query\":{\"filtered\":{ %s,\"filter\": { \"and\" : [ %s ] } }}}";
    private static String PUSH_DOWN_ES_5X = "{\"query\":{\"bool\":{ \"must\":{%s},\"filter\": [ %s ] }}}";

    QueryUtils() {
    }

    static BytesArray parseQuery(Settings settings) {
        String query = settings.getQuery();
        if (!StringUtils.hasText(query)) {
            query = MATCH_ALL;
        }
        if ((query = query.trim()).startsWith("?")) {
            return new BytesArray(QueryUtils.translateUriQuery(query));
        }
        if (query.startsWith("{")) {
            return new BytesArray(query);
        }
        try {
            InputStream in = settings.loadResource(query);
            int first = in.read();
            if (Integer.valueOf(63).equals(first)) {
                return new BytesArray(QueryUtils.translateUriQuery(IOUtils.asString(in)));
            }
            BytesArray content = new BytesArray(1024);
            content.add(first);
            IOUtils.asBytes(content, in);
            return content;
        }
        catch (IOException ex) {
            throw new EsHadoopIllegalArgumentException(String.format("Cannot determine specified query - doesn't appear to be URI or JSON based and location [%s] cannot be opened", query));
        }
    }

    private static String translateUriQuery(String query) {
        if (query.startsWith("?")) {
            query = query.substring(1);
        }
        LinkedHashMap<String, String> params2 = new LinkedHashMap<String, String>();
        for (String token : query.split("&")) {
            int indexOf = token.indexOf("=");
            Assert.isTrue(indexOf > 0, String.format("Cannot token [%s] in uri query [%s]", token, query));
            params2.put(token.substring(0, indexOf), token.substring(indexOf + 1));
        }
        LinkedHashMap translated = new LinkedHashMap();
        for (Map.Entry entry : params2.entrySet()) {
            String translatedKey = URI_QUERY_TO_DSL.get(entry.getKey());
            Assert.hasText(translatedKey, String.format("Unknown '%s' parameter; please change the URI query into a Query DLS (see 'Query String Query')", entry.getKey()));
            translated.put(translatedKey, entry.getValue());
        }
        if (translated.containsKey("query")) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : translated.entrySet()) {
                sb.append(QueryUtils.addQuotes((String)entry.getKey()));
                sb.append(":");
                sb.append(QueryUtils.addQuotes((String)entry.getValue()));
                sb.append(",");
            }
            return String.format(QUERY_STRING_QUERY, sb.substring(0, sb.length() - 1));
        }
        return MATCH_ALL;
    }

    private static String addQuotes(String value) {
        boolean lead = value.startsWith(QUOTE);
        boolean trail = value.endsWith(QUOTE);
        if (lead && trail) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        if (!lead) {
            sb.append(QUOTE);
        }
        sb.append(value);
        if (!trail) {
            sb.append(QUOTE);
        }
        return sb.toString();
    }

    static BytesArray applyFilters(boolean isES5X, BytesArray bodyQuery, String ... filters) {
        if (filters == null || filters.length == 0) {
            return bodyQuery;
        }
        String originalQuery = bodyQuery.toString();
        int start = originalQuery.indexOf("{");
        int stop = originalQuery.lastIndexOf("}");
        String msg = String.format("Cannot apply filter(s) to what looks like an invalid DSL query (no leading/trailing { } ): '%s' ", originalQuery);
        Assert.isTrue(start >= 0, msg);
        Assert.isTrue(stop >= 0, msg);
        Assert.isTrue(stop - start > 0, msg);
        String query = null;
        if (isES5X) {
            String nestedQuery = QueryUtils.stripQuery(originalQuery);
            query = String.format(PUSH_DOWN_ES_5X, nestedQuery, StringUtils.concatenate(filters, ","));
        } else {
            String nestedQuery = originalQuery.substring(start + 1, stop);
            query = String.format(PUSH_DOWN, nestedQuery, StringUtils.concatenate(filters, ","));
        }
        return new BytesArray(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String stripQuery(String query) {
        JacksonJsonParser parser = new JacksonJsonParser(new FastByteArrayInputStream(StringUtils.toUTF(query)));
        try {
            Parser.Token queryField = ParsingUtils.seek((Parser)parser, "query");
            Assert.isTrue(queryField != null, "Invalid QueryDSL - cannot find 'query' field");
            parser.nextToken();
            int queryStartOffset = parser.tokenCharOffset();
            ParsingUtils.skipCurrentBlock(parser);
            int queryStopOffset = parser.tokenCharOffset();
            String string = query.substring(queryStartOffset, queryStopOffset);
            return string;
        }
        finally {
            parser.close();
        }
    }

    static {
        URI_QUERY_TO_DSL.put("q", "query");
        URI_QUERY_TO_DSL.put("df", "default_field");
        URI_QUERY_TO_DSL.put("analyzer", "analyzer");
        URI_QUERY_TO_DSL.put("lowercase_expanded_terms", "lowercase_expanded_terms");
        URI_QUERY_TO_DSL.put("analyze_wildcard", "analyze_wildcard");
        URI_QUERY_TO_DSL.put("default_operator", "default_operator");
        URI_QUERY_TO_DSL.put("lenient", "lenient");
    }
}

