/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.storm.serialization;

import backtype.storm.tuple.Tuple;
import org.elasticsearch.hadoop.serialization.JdkBytesConverter;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;

public class StormTupleBytesConverter
extends JdkBytesConverter {
    @Override
    public void convert(Object from, BytesArray to) {
        Assert.isTrue(from == null || from instanceof Tuple, String.format("Unexpected object type, expecting [%s], given [%s]", Tuple.class, from.getClass()));
        Tuple tuple = (Tuple)from;
        if (tuple == null || tuple.size() == 0) {
            to.bytes("{}");
            return;
        }
        Assert.isTrue(tuple.size() == 1, "When using JSON input, only one field is expected");
        super.convert(tuple.getValue(0), to);
    }
}

