/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.sql;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.RestRepository;
import org.elasticsearch.hadoop.serialization.FieldType;
import org.elasticsearch.hadoop.serialization.dto.mapping.Field;
import org.elasticsearch.hadoop.serialization.dto.mapping.MappingUtils;
import org.elasticsearch.hadoop.serialization.field.FieldFilter;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.spark.sql.SchemaUtils;
import org.elasticsearch.spark.sql.Utils;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class SchemaUtils$ {
    public static final SchemaUtils$ MODULE$;
    private final String readInclude;
    private final String readExclude;

    static {
        new SchemaUtils$();
    }

    public String readInclude() {
        return this.readInclude;
    }

    public String readExclude() {
        return this.readExclude;
    }

    public SchemaUtils.Schema discoverMapping(Settings cfg) {
        Field field = this.discoverMappingAsField(cfg);
        StructType struct = this.convertToStruct(field, cfg);
        return new SchemaUtils.Schema(field, struct);
    }

    public Field discoverMappingAsField(Settings cfg) {
        try (RestRepository repo = new RestRepository(cfg);){
            if (repo.indexExists(true)) {
                Field field = repo.getMapping().skipHeaders();
                String readIncludeCfg = cfg.getProperty(this.readInclude());
                String readExcludeCfg = cfg.getProperty(this.readExclude());
                if (StringUtils.hasText(readIncludeCfg) || StringUtils.hasText(readExcludeCfg)) {
                    List<String> includes = StringUtils.tokenize(readIncludeCfg);
                    List<String> excludes = StringUtils.tokenize(readExcludeCfg);
                    field = MappingUtils.filter(field, includes, excludes);
                    cfg.setProperty("es.internal.mr.target.fields", StringUtils.concatenate(Field.toLookupMap(field).keySet()));
                }
                return field;
            }
            throw new EsHadoopIllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find mapping for ", " - one is required before using Spark SQL"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cfg.getResourceRead()})));
        }
    }

    private StructType convertToStruct(Field rootField, Settings cfg) {
        List<String> arrayIncludes = StringUtils.tokenize(cfg.getFieldReadAsArrayInclude());
        List<String> arrayExcludes = StringUtils.tokenize(cfg.getFieldReadAsArrayExclude());
        StructField[] fields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])rootField.properties()).map((Function1)new Serializable(arrayIncludes, arrayExcludes){
            public static final long serialVersionUID = 0L;
            private final List arrayIncludes$2;
            private final List arrayExcludes$2;

            public final StructField apply(Field fl) {
                return SchemaUtils$.MODULE$.org$elasticsearch$spark$sql$SchemaUtils$$convertField(fl, null, this.arrayIncludes$2, this.arrayExcludes$2);
            }
            {
                this.arrayIncludes$2 = arrayIncludes$2;
                this.arrayExcludes$2 = arrayExcludes$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        if (cfg.getReadMetadata()) {
            StructField metadataMap = DataTypes.createStructField((String)cfg.getReadMetadataField(), (DataType)DataTypes.createMapType((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$, (boolean)true), (boolean)true);
            fields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])fields).$colon$plus((Object)metadataMap, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        }
        return DataTypes.createStructType((StructField[])fields);
    }

    private StructType convertToStruct(Field field, String parentName, List<String> arrayIncludes, List<String> arrayExcludes) {
        return DataTypes.createStructType((StructField[])((StructField[])Predef$.MODULE$.refArrayOps((Object[])field.properties()).map((Function1)new Serializable(parentName, arrayIncludes, arrayExcludes){
            public static final long serialVersionUID = 0L;
            private final String parentName$1;
            private final List arrayIncludes$1;
            private final List arrayExcludes$1;

            public final StructField apply(Field fl) {
                return SchemaUtils$.MODULE$.org$elasticsearch$spark$sql$SchemaUtils$$convertField(fl, this.parentName$1, this.arrayIncludes$1, this.arrayExcludes$1);
            }
            {
                this.parentName$1 = parentName$1;
                this.arrayIncludes$1 = arrayIncludes$1;
                this.arrayExcludes$1 = arrayExcludes$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))));
    }

    public StructField org$elasticsearch$spark$sql$SchemaUtils$$convertField(Field field, String parentName, List<String> arrayIncludes, List<String> arrayExcludes) {
        Object object;
        String absoluteName = parentName == null ? field.name() : new StringBuilder().append((Object)parentName).append((Object)".").append((Object)field.name()).toString();
        boolean createArray = arrayIncludes.isEmpty() ? false : FieldFilter.filter(absoluteName, arrayIncludes, arrayExcludes, false);
        FieldType fieldType = Utils.extractType(field);
        FieldType fieldType2 = FieldType.NULL;
        FieldType fieldType3 = fieldType;
        if (!(fieldType2 != null ? !((Object)((Object)fieldType2)).equals((Object)fieldType3) : fieldType3 != null)) {
            object = NullType$.MODULE$;
        } else {
            FieldType fieldType4 = FieldType.BINARY;
            FieldType fieldType5 = fieldType;
            if (!(fieldType4 != null ? !((Object)((Object)fieldType4)).equals((Object)fieldType5) : fieldType5 != null)) {
                object = BinaryType$.MODULE$;
            } else {
                FieldType fieldType6 = FieldType.BOOLEAN;
                FieldType fieldType7 = fieldType;
                if (!(fieldType6 != null ? !((Object)((Object)fieldType6)).equals((Object)fieldType7) : fieldType7 != null)) {
                    object = BooleanType$.MODULE$;
                } else {
                    FieldType fieldType8 = FieldType.BYTE;
                    FieldType fieldType9 = fieldType;
                    if (!(fieldType8 != null ? !((Object)((Object)fieldType8)).equals((Object)fieldType9) : fieldType9 != null)) {
                        object = ByteType$.MODULE$;
                    } else {
                        FieldType fieldType10 = FieldType.SHORT;
                        FieldType fieldType11 = fieldType;
                        if (!(fieldType10 != null ? !((Object)((Object)fieldType10)).equals((Object)fieldType11) : fieldType11 != null)) {
                            object = ShortType$.MODULE$;
                        } else {
                            FieldType fieldType12 = FieldType.INTEGER;
                            FieldType fieldType13 = fieldType;
                            if (!(fieldType12 != null ? !((Object)((Object)fieldType12)).equals((Object)fieldType13) : fieldType13 != null)) {
                                object = IntegerType$.MODULE$;
                            } else {
                                FieldType fieldType14 = FieldType.LONG;
                                FieldType fieldType15 = fieldType;
                                if (!(fieldType14 != null ? !((Object)((Object)fieldType14)).equals((Object)fieldType15) : fieldType15 != null)) {
                                    object = LongType$.MODULE$;
                                } else {
                                    FieldType fieldType16 = FieldType.FLOAT;
                                    FieldType fieldType17 = fieldType;
                                    if (!(fieldType16 != null ? !((Object)((Object)fieldType16)).equals((Object)fieldType17) : fieldType17 != null)) {
                                        object = FloatType$.MODULE$;
                                    } else {
                                        FieldType fieldType18 = FieldType.DOUBLE;
                                        FieldType fieldType19 = fieldType;
                                        if (!(fieldType18 != null ? !((Object)((Object)fieldType18)).equals((Object)fieldType19) : fieldType19 != null)) {
                                            object = DoubleType$.MODULE$;
                                        } else {
                                            FieldType fieldType20 = FieldType.STRING;
                                            FieldType fieldType21 = fieldType;
                                            if (!(fieldType20 != null ? !((Object)((Object)fieldType20)).equals((Object)fieldType21) : fieldType21 != null)) {
                                                object = StringType$.MODULE$;
                                            } else {
                                                FieldType fieldType22 = FieldType.DATE;
                                                FieldType fieldType23 = fieldType;
                                                if (!(fieldType22 != null ? !((Object)((Object)fieldType22)).equals((Object)fieldType23) : fieldType23 != null)) {
                                                    object = TimestampType$.MODULE$;
                                                } else {
                                                    FieldType fieldType24 = FieldType.OBJECT;
                                                    FieldType fieldType25 = fieldType;
                                                    object = !(fieldType24 != null ? !((Object)((Object)fieldType24)).equals((Object)fieldType25) : fieldType25 != null) ? this.convertToStruct(field, absoluteName, arrayIncludes, arrayExcludes) : StringType$.MODULE$;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        NullType$ dataType = object;
        return DataTypes.createStructField((String)field.name(), (DataType)(createArray ? DataTypes.createArrayType((DataType)dataType) : dataType), (boolean)true);
    }

    public void setRowInfo(Settings settings, StructType struct) {
        Tuple2<Properties, Properties> rowInfo = this.detectRowInfo(settings, struct);
        settings.setProperty(Utils.ROW_INFO_ORDER_PROPERTY, IOUtils.propsToString((Properties)rowInfo._1()));
        settings.setProperty(Utils.ROW_INFO_ARRAY_PROPERTY, IOUtils.propsToString((Properties)rowInfo._2()));
    }

    public Tuple2<LinkedHashMap<String, Seq<String>>, LinkedHashSet<String>> getRowInfo(Settings settings) {
        String rowOrderString = settings.getProperty(Utils.ROW_INFO_ORDER_PROPERTY);
        Assert.hasText(rowOrderString, "no schema/row order detected...");
        Properties rowOrderProps = IOUtils.propsFromString(rowOrderString);
        String rowArrayString = settings.getProperty(Utils.ROW_INFO_ARRAY_PROPERTY);
        Properties rowArrayProps = StringUtils.hasText(rowArrayString) ? IOUtils.propsFromString(rowArrayString) : new Properties();
        LinkedHashMap order = new LinkedHashMap();
        ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(rowOrderProps).asScala()).foreach((Function1)new Serializable(order){
            public static final long serialVersionUID = 0L;
            private final LinkedHashMap order$1;

            public final Object apply(Tuple2<String, String> prop) {
                Buffer value = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(StringUtils.tokenize((String)prop._2())).asScala();
                return value.isEmpty() ? BoxedUnit.UNIT : this.order$1.put(prop._1(), (Object)new ArrayBuffer().$plus$plus$eq((TraversableOnce)value));
            }
            {
                this.order$1 = order$1;
            }
        });
        LinkedHashSet needToBeArray = new LinkedHashSet();
        ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(rowArrayProps).asScala()).foreach((Function1)new Serializable(needToBeArray){
            public static final long serialVersionUID = 0L;
            private final LinkedHashSet needToBeArray$1;

            public final boolean apply(Tuple2<String, String> prop) {
                return this.needToBeArray$1.add(prop._1());
            }
            {
                this.needToBeArray$1 = needToBeArray$1;
            }
        });
        return new Tuple2((Object)order, needToBeArray);
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<Properties, Properties> detectRowInfo(Settings settings, StructType struct) {
        void var3_3;
        Tuple2 rowInfo = new Tuple2((Object)new Properties(), (Object)new Properties());
        this.org$elasticsearch$spark$sql$SchemaUtils$$doDetectInfo((Tuple2<Properties, Properties>)rowInfo, Utils.ROOT_LEVEL_NAME, struct);
        String csv = settings.getScrollFields();
        Object object = StringUtils.hasText(csv) ? (settings.getReadMetadata() ? ((Properties)rowInfo._1()).setProperty(Utils.ROOT_LEVEL_NAME, new StringBuilder().append((Object)csv).append((Object)",").append((Object)settings.getReadMetadataField()).toString()) : ((Properties)rowInfo._1()).setProperty(Utils.ROOT_LEVEL_NAME, csv)) : BoxedUnit.UNIT;
        return var3_3;
    }

    public void org$elasticsearch$spark$sql$SchemaUtils$$doDetectInfo(Tuple2<Properties, Properties> info, String level, StructType struct) {
        ArrayList fields = new ArrayList();
        struct.foreach((Function1)new Serializable(info, level, fields){
            public static final long serialVersionUID = 0L;
            private final Tuple2 info$1;
            private final String level$1;
            private final ArrayList fields$1;

            public final void apply(StructField field) {
                this.fields$1.add(field.name());
                DataType dataType = field.dataType();
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    String string = this.level$1;
                    String string2 = Utils.ROOT_LEVEL_NAME;
                    SchemaUtils$.MODULE$.org$elasticsearch$spark$sql$SchemaUtils$$doDetectInfo((Tuple2<Properties, Properties>)this.info$1, !(string != null ? !string.equals(string2) : string2 != null) ? field.name() : new StringBuilder().append((Object)this.level$1).append((Object)".").append((Object)field.name()).toString(), structType);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    String string = this.level$1;
                    String string3 = Utils.ROOT_LEVEL_NAME;
                    String absoluteName = !(string != null ? !string.equals(string3) : string3 != null) ? field.name() : new StringBuilder().append((Object)this.level$1).append((Object)".").append((Object)field.name()).toString();
                    ((Properties)this.info$1._2()).setProperty(absoluteName, "");
                    DataType dataType2 = arrayType.elementType();
                    if (dataType2 instanceof StructType) {
                        StructType structType = (StructType)dataType2;
                        SchemaUtils$.MODULE$.org$elasticsearch$spark$sql$SchemaUtils$$doDetectInfo((Tuple2<Properties, Properties>)this.info$1, absoluteName, structType);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.info$1 = info$1;
                this.level$1 = level$1;
                this.fields$1 = fields$1;
            }
        });
        ((Properties)info._1()).setProperty(level, StringUtils.concatenate(fields, ","));
    }

    private SchemaUtils$() {
        MODULE$ = this;
        this.readInclude = "es.read.field.include";
        this.readExclude = "es.read.field.exclude";
    }
}

