/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.yarn.util;

import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.elasticsearch.hadoop.yarn.compat.YarnCompat;

public abstract class YarnUtils {
    public static ApplicationAttemptId getApplicationAttemptId(Map<String, String> env) {
        if (env == null) {
            return null;
        }
        String amContainerId = env.get(ApplicationConstants.Environment.CONTAINER_ID.name());
        if (amContainerId == null) {
            return null;
        }
        ContainerId containerId = ConverterUtils.toContainerId((String)amContainerId);
        return containerId.getApplicationAttemptId();
    }

    public static InetSocketAddress getResourceManagerAddr(Configuration cfg) {
        return cfg.getSocketAddr("yarn.resourcemanager.scheduler.address", "0.0.0.0:8030", 8030);
    }

    public static long getAmHeartBeatRate(Configuration cfg) {
        return cfg.getLong("yarn.am.liveness-monitor.expiry-interval-ms", 600000L);
    }

    public static Map<String, String> setupEnv(Configuration cfg) {
        LinkedHashMap<String, String> env = new LinkedHashMap<String, String>();
        for (String c : cfg.getStrings("yarn.application.classpath", YarnCompat.DEFAULT_PLATFORM_APPLICATION_CLASSPATH())) {
            YarnUtils.addToEnv(env, ApplicationConstants.Environment.CLASSPATH.name(), c.trim());
        }
        YarnUtils.addToEnv(env, ApplicationConstants.Environment.CLASSPATH.name(), "./*");
        YarnUtils.addToEnv(env, "ES_YARN_FS_URI", cfg.get("fs.defaultFS", "file:///"));
        return env;
    }

    public static void addToEnv(Map<String, String> env, String key, String value) {
        String val = env.get(key);
        val = val == null ? value : val + YarnCompat.CLASS_PATH_SEPARATOR() + value;
        env.put(key, val);
    }

    public static void addToEnv(Map<String, String> env, Map<String, String> envVars) {
        for (Map.Entry<String, String> entry : envVars.entrySet()) {
            YarnUtils.addToEnv(env, entry.getKey(), entry.getValue());
        }
    }

    public static Object minVCores(Configuration cfg, int vCores) {
        return YarnUtils.yarnAcceptableMin(cfg, "yarn.scheduler.minimum-allocation-vcores", vCores);
    }

    public static int minMemory(Configuration cfg, int memory) {
        return YarnUtils.yarnAcceptableMin(cfg, "yarn.scheduler.minimum-allocation-mb", memory);
    }

    private static int yarnAcceptableMin(Configuration cfg, String property, int value) {
        int acceptedVal = Integer.parseInt(cfg.get(property));
        if (acceptedVal >= value) {
            return acceptedVal;
        }
        if (value % acceptedVal != 0) {
            return acceptedVal * Math.round(value / acceptedVal);
        }
        return value;
    }

    public static ApplicationId createAppIdFrom(String appId) {
        appId = appId.substring("application_".length());
        int delimiter = appId.indexOf("-");
        return ApplicationId.newInstance((long)Long.parseLong(appId.substring(0, delimiter)), (int)Integer.parseInt(appId.substring(delimiter + 1)));
    }
}

