/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.hive;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.hive.HiveType;
import org.elasticsearch.hadoop.hive.HiveUtils;
import org.elasticsearch.hadoop.hive.HiveWritableValueWriter;
import org.elasticsearch.hadoop.serialization.Generator;
import org.elasticsearch.hadoop.serialization.builder.FilteringValueWriter;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;
import org.elasticsearch.hadoop.util.FieldAlias;

public class HiveValueWriter
extends FilteringValueWriter<HiveType> {
    private final boolean writeUnknownTypes;
    private final HiveWritableValueWriter writableWriter = new HiveWritableValueWriter(false);
    private FieldAlias alias = new FieldAlias(true);

    public HiveValueWriter() {
        this.writeUnknownTypes = false;
    }

    @Override
    public ValueWriter.Result write(HiveType type, Generator generator) {
        return this.write(type.getObject(), type.getObjectInspector(), generator);
    }

    private ValueWriter.Result write(Object data, ObjectInspector oi, Generator generator) {
        if (data == null) {
            generator.writeNull();
            return ValueWriter.Result.SUCCESFUL();
        }
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                Writable writable = (Writable)((PrimitiveObjectInspector)oi).getPrimitiveWritableObject(data);
                return this.writableWriter.write(writable, generator);
            }
            case LIST: {
                ListObjectInspector loi = (ListObjectInspector)oi;
                generator.writeBeginArray();
                for (int i = 0; i < loi.getListLength(data); ++i) {
                    ValueWriter.Result result = this.write(loi.getListElement(data, i), loi.getListElementObjectInspector(), generator);
                    if (result.isSuccesful()) continue;
                    return result;
                }
                generator.writeEndArray();
                break;
            }
            case MAP: {
                MapObjectInspector moi = (MapObjectInspector)oi;
                generator.writeBeginObject();
                for (Map.Entry entry : moi.getMap(data).entrySet()) {
                    String fieldName = entry.getKey().toString();
                    if (!this.shouldKeep(generator.getParentPath(), fieldName)) continue;
                    generator.writeFieldName(this.alias.toES(entry.getKey().toString()));
                    ValueWriter.Result result = this.write(entry.getValue(), moi.getMapValueObjectInspector(), generator);
                    if (result.isSuccesful()) continue;
                    return result;
                }
                generator.writeEndObject();
                break;
            }
            case STRUCT: {
                StructObjectInspector soi = (StructObjectInspector)oi;
                List refs = soi.getAllStructFieldRefs();
                generator.writeBeginObject();
                for (StructField structField : refs) {
                    if (!this.shouldKeep(generator.getParentPath(), structField.getFieldName())) continue;
                    generator.writeFieldName(this.alias.toES(structField.getFieldName()));
                    ValueWriter.Result result = this.write(soi.getStructFieldData(data, structField), structField.getFieldObjectInspector(), generator);
                    if (result.isSuccesful()) continue;
                    return result;
                }
                generator.writeEndObject();
                break;
            }
            case UNION: {
                throw new UnsupportedOperationException("union not yet supported");
            }
            default: {
                if (this.writeUnknownTypes) {
                    return this.handleUnknown(data, oi, generator);
                }
                return ValueWriter.Result.FAILED(data);
            }
        }
        return ValueWriter.Result.SUCCESFUL();
    }

    protected ValueWriter.Result handleUnknown(Object value, ObjectInspector oi, Generator generator) {
        return ValueWriter.Result.FAILED(value);
    }

    @Override
    public void setSettings(Settings settings) {
        super.setSettings(settings);
        this.alias = HiveUtils.alias(settings);
        this.writableWriter.setSettings(settings);
    }
}

