/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.storm.serialization;

import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import org.elasticsearch.hadoop.serialization.Generator;
import org.elasticsearch.hadoop.serialization.builder.JdkValueWriter;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;

public class StormValueWriter
implements ValueWriter<Tuple> {
    private final ValueWriter<Object> jdkWriter;

    public StormValueWriter() {
        this(false);
    }

    public StormValueWriter(boolean writeUnknownTypes) {
        this.jdkWriter = new JdkValueWriter(writeUnknownTypes);
    }

    @Override
    public boolean write(Tuple tuple, Generator generator) {
        Fields fields = tuple.getFields();
        generator.writeBeginObject();
        for (String field : fields) {
            generator.writeFieldName(field);
            Object value = tuple.getValueByField(field);
            if (!(value instanceof Tuple ? !this.write((Tuple)value, generator) : !this.jdkWriter.write(value, generator))) continue;
            return false;
        }
        generator.writeEndObject();
        return true;
    }
}

