/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.rdd;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.TaskContext;
import org.elasticsearch.hadoop.cfg.PropertiesSettings;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.rest.RestService;
import org.elasticsearch.hadoop.serialization.BytesConverter;
import org.elasticsearch.hadoop.serialization.JdkBytesConverter;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;
import org.elasticsearch.spark.serialization.ScalaMapFieldExtractor;
import org.elasticsearch.spark.serialization.ScalaValueWriter;
import scala.Function0;
import scala.Serializable;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ec!B\u0001\u0003\u0001\u0011Q!aC#t%\u0012#uK]5uKJT!a\u0001\u0003\u0002\u0007I$GM\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\u000eK2\f7\u000f^5dg\u0016\f'o\u00195\u000b\u0003%\t1a\u001c:h+\tYAfE\u0002\u0001\u0019I\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007CA\u0007\u0014\u0013\t!bB\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u0017\u0001\t\u0015\r\u0011\"\u0001\u0019\u0003I\u0019XM]5bY&TX\rZ*fiRLgnZ:\u0004\u0001U\t\u0011\u0004\u0005\u0002\u001b;9\u0011QbG\u0005\u000399\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0010 \u0005\u0019\u0019FO]5oO*\u0011AD\u0004\u0005\tC\u0001\u0011\t\u0011)A\u00053\u0005\u00192/\u001a:jC2L'0\u001a3TKR$\u0018N\\4tA!A1\u0005\u0001B\u0002B\u0003-A%\u0001\u0006fm&$WM\\2fIE\u00022!\n\u0015+\u001b\u00051#BA\u0014\u000f\u0003\u001d\u0011XM\u001a7fGRL!!\u000b\u0014\u0003\u0011\rc\u0017m]:UC\u001e\u0004\"a\u000b\u0017\r\u0001\u0011)Q\u0006\u0001b\u0001]\t\tA+\u0005\u00020eA\u0011Q\u0002M\u0005\u0003c9\u0011qAT8uQ&tw\r\u0005\u0002\u000eg%\u0011AG\u0004\u0002\u0004\u0003:L\b\"\u0002\u001c\u0001\t\u00039\u0014A\u0002\u001fj]&$h\b\u0006\u00029yQ\u0011\u0011h\u000f\t\u0004u\u0001QS\"\u0001\u0002\t\u000b\r*\u00049\u0001\u0013\t\u000bY)\u0004\u0019A\r\t\u000fy\u0002!\u0019!C\t\u007f\u0005\u0019An\\4\u0016\u0003\u0001\u0003\"!\u0011%\u000e\u0003\tS!a\u0011#\u0002\u000f1|wmZ5oO*\u0011QIR\u0001\bG>lWn\u001c8t\u0015\t9\u0005\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003\u0013\n\u00131\u0001T8h\u0011\u0019Y\u0005\u0001)A\u0005\u0001\u0006!An\\4!\u0011!i\u0005\u0001#b\u0001\n\u0003q\u0015\u0001C:fiRLgnZ:\u0016\u0003=\u0003\"\u0001U+\u000e\u0003ES!AU*\u0002\u0007\r4wM\u0003\u0002U\r\u00051\u0001.\u00193p_BL!AV)\u0003\u0011M+G\u000f^5oOND\u0001\u0002\u0017\u0001\t\u0002\u0003\u0006KaT\u0001\ng\u0016$H/\u001b8hg\u0002BQA\u0017\u0001\u0005\u0002m\u000bQa\u001e:ji\u0016$2\u0001X0g!\tiQ,\u0003\u0002_\u001d\t!QK\\5u\u0011\u0015\u0001\u0017\f1\u0001b\u0003-!\u0018m]6D_:$X\r\u001f;\u0011\u0005\t$W\"A2\u000b\u0005\u00151\u0015BA3d\u0005-!\u0016m]6D_:$X\r\u001f;\t\u000b\u001dL\u0006\u0019\u00015\u0002\t\u0011\fG/\u0019\t\u0004SFTcB\u00016p\u001d\tYg.D\u0001m\u0015\tiw#\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0011\u0001OD\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00118O\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\t\u0001h\u0002C\u0003v\u0001\u0011Ea/A\u0006wC2,Xm\u0016:ji\u0016\u0014X#A<1\u0005ad\bc\u0001\u000ezw&\u0011!p\b\u0002\u0006\u00072\f7o\u001d\t\u0003Wq$\u0011\" ;\u0002\u0002\u0003\u0005)\u0011\u0001@\u0003\u0007}#\u0013'\u0005\u00020\u007fB\"\u0011\u0011AA\n!\u0019\t\u0019!!\u0004\u0002\u00125\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!A\u0004ck&dG-\u001a:\u000b\u0007\u0005-1+A\u0007tKJL\u0017\r\\5{CRLwN\\\u0005\u0005\u0003\u001f\t)AA\u0006WC2,Xm\u0016:ji\u0016\u0014\bcA\u0016\u0002\u0014\u0011Y\u0011QCA\f\u0003\u0003\u0005\tQ!\u0001/\u0005\ryFE\r\u0003\n{R\f\t1!A\u0003\u0002yDq!a\u0007\u0001\t#\ti\"\u0001\bcsR,7oQ8om\u0016\u0014H/\u001a:\u0016\u0005\u0005}\u0001\u0007BA\u0011\u0003K\u0001BAG=\u0002$A\u00191&!\n\u0005\u0019\u0005\u001d\u0012\u0011DA\u0001\u0002\u0003\u0015\t!!\u000b\u0003\u0007}#3'E\u00020\u0003W\u0001B!!\f\u000205\u0011\u0011\u0011B\u0005\u0005\u0003c\tIA\u0001\bCsR,7oQ8om\u0016\u0014H/\u001a:\t\u000f\u0005U\u0002\u0001\"\u0005\u00028\u0005qa-[3mI\u0016CHO]1di>\u0014XCAA\u001da\u0011\tY$a\u0010\u0011\tiI\u0018Q\b\t\u0004W\u0005}B\u0001DA!\u0003g\t\t\u0011!A\u0003\u0002\u0005\r#aA0%iE\u0019q&!\u0012\u0011\t\u0005\u001d\u0013QJ\u0007\u0003\u0003\u0013RA!a\u0013\u0002\n\u0005)a-[3mI&!\u0011qJA%\u000591\u0015.\u001a7e\u000bb$(/Y2u_JDq!a\u0015\u0001\t#\t)&A\u0006qe>\u001cWm]:ECR\fGc\u0001\u001a\u0002X!1q-!\u0015A\u0002!\u0004")
public class EsRDDWriter<T>
implements Serializable {
    private final String serializedSettings;
    private final Log log;
    private Settings settings;
    private volatile boolean bitmap$0;

    private Settings settings$lzycompute() {
        EsRDDWriter esRDDWriter = this;
        synchronized (esRDDWriter) {
            if (!this.bitmap$0) {
                this.settings = new PropertiesSettings().load(this.serializedSettings());
                this.bitmap$0 = true;
            }
            return this.settings;
        }
    }

    public String serializedSettings() {
        return this.serializedSettings;
    }

    public Log log() {
        return this.log;
    }

    public Settings settings() {
        return this.bitmap$0 ? this.settings : this.settings$lzycompute();
    }

    public void write(TaskContext taskContext, Iterator<T> data) {
        InitializationUtils.setValueWriterIfNotSet(this.settings(), this.valueWriter(), this.log());
        InitializationUtils.setBytesConverterIfNeeded(this.settings(), this.bytesConverter(), this.log());
        InitializationUtils.setFieldExtractorIfNotSet(this.settings(), this.fieldExtractor(), this.log());
        RestService.PartitionWriter writer = RestService.createWriter(this.settings(), taskContext.partitionId(), -1, this.log());
        taskContext.addOnCompleteCallback((Function0)new Serializable(this, writer){
            public static final long serialVersionUID = 0L;
            private final RestService.PartitionWriter writer$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.writer$1.close();
            }
            {
                this.writer$1 = writer$1;
            }
        });
        while (data.hasNext()) {
            writer.repository.writeToIndex(this.processData(data));
        }
    }

    public Class<? extends ValueWriter<?>> valueWriter() {
        return ScalaValueWriter.class;
    }

    public Class<? extends BytesConverter> bytesConverter() {
        return JdkBytesConverter.class;
    }

    public Class<? extends FieldExtractor> fieldExtractor() {
        return ScalaMapFieldExtractor.class;
    }

    public Object processData(Iterator<T> data) {
        return data.next();
    }

    public EsRDDWriter(String serializedSettings, ClassTag<T> evidence$1) {
        this.serializedSettings = serializedSettings;
        this.log = LogFactory.getLog(this.getClass());
    }
}

