/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.yarn.client;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.elasticsearch.hadoop.yarn.EsYarnException;
import org.elasticsearch.hadoop.yarn.util.YarnUtils;

public class ClientRpc
implements AutoCloseable {
    private static final Set<String> ES_TYPE = Collections.singleton("ELASTICSEARCH");
    private static final EnumSet<YarnApplicationState> ALIVE = EnumSet.range(YarnApplicationState.NEW, YarnApplicationState.RUNNING);
    private YarnClient client;
    private final Configuration cfg;

    public ClientRpc(Configuration cfg) {
        this.cfg = new YarnConfiguration(cfg);
    }

    public void start() {
        if (this.client != null) {
            return;
        }
        if (UserGroupInformation.isSecurityEnabled()) {
            UserGroupInformation.setConfiguration((Configuration)this.cfg);
        }
        this.client = YarnClient.createYarnClient();
        this.client.init(this.cfg);
        this.client.start();
    }

    public YarnClientApplication newApp() {
        try {
            return this.client.createApplication();
        }
        catch (Exception ex) {
            throw new EsYarnException(ex);
        }
    }

    public ApplicationId submitApp(ApplicationSubmissionContext appContext) {
        try {
            return this.client.submitApplication(appContext);
        }
        catch (Exception ex) {
            throw new EsYarnException(ex);
        }
    }

    public List<ApplicationReport> killEsApps() {
        try {
            List esApps = this.client.getApplications(ES_TYPE, ALIVE);
            for (ApplicationReport appReport : esApps) {
                this.client.killApplication(appReport.getApplicationId());
            }
            return esApps;
        }
        catch (Exception ex) {
            throw new EsYarnException(ex);
        }
    }

    public void killApp(String appId) {
        try {
            this.client.killApplication(YarnUtils.createAppIdFrom(appId));
        }
        catch (Exception ex) {
            throw new EsYarnException(ex);
        }
    }

    public ApplicationReport getReport(ApplicationId appId) {
        try {
            return this.client.getApplicationReport(appId);
        }
        catch (Exception ex) {
            throw new EsYarnException(ex);
        }
    }

    public List<ApplicationReport> listApps() {
        try {
            return this.client.getApplications();
        }
        catch (Exception ex) {
            throw new EsYarnException(ex);
        }
    }

    public List<ApplicationReport> listEsClusters() {
        try {
            return this.client.getApplications(ES_TYPE);
        }
        catch (Exception ex) {
            throw new EsYarnException(ex);
        }
    }

    public List<ApplicationReport> listEsClustersAlive() {
        try {
            return this.client.getApplications(ES_TYPE, ALIVE);
        }
        catch (Exception ex) {
            throw new EsYarnException(ex);
        }
    }

    public void waitForApp(ApplicationId appId, long timeout) {
        boolean repeat = false;
        long start = System.currentTimeMillis();
        do {
            try {
                ApplicationReport appReport = this.client.getApplicationReport(appId);
                YarnApplicationState appState = appReport.getYarnApplicationState();
                boolean bl = repeat = appState != YarnApplicationState.FINISHED && appState != YarnApplicationState.KILLED && appState != YarnApplicationState.FAILED;
                if (!repeat) continue;
                Thread.sleep(500L);
            }
            catch (Exception ex) {
                throw new EsYarnException(ex);
            }
        } while (repeat && System.currentTimeMillis() - start < timeout);
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.stop();
            this.client = null;
        }
    }

    public Configuration getConfiguration() {
        return this.cfg;
    }
}

