/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.dto;

import java.io.Serializable;
import java.util.Map;

public class Node
implements Serializable {
    private String id;
    private String name;
    private boolean hasHttp;
    private String ipAddress;
    private int httpPort;

    public Node(String id, Map<String, Object> data) {
        this.id = id;
        this.name = data.get("name").toString();
        Object http = data.get("http_address");
        boolean bl = this.hasHttp = http != null;
        if (!this.hasHttp) {
            return;
        }
        String httpAddr = http.toString();
        int startIndex = httpAddr.indexOf("/") + 1;
        int endIndex = httpAddr.indexOf(":");
        this.ipAddress = httpAddr.substring(startIndex, endIndex);
        this.httpPort = Integer.valueOf(httpAddr.substring(endIndex + 1, httpAddr.indexOf("]")));
    }

    public boolean hasHttp() {
        return this.hasHttp;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Node[id=").append(this.id).append(", name=").append(this.name).append(", ipAddress=").append(this.ipAddress).append(", httpPort=").append(this.httpPort).append("]");
        return builder.toString();
    }
}

