/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.mr;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.util.Progressable;
import org.elasticsearch.hadoop.mr.HadoopCfgUtils;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.unit.TimeValue;

class HeartBeat {
    private ScheduledExecutorService scheduler;
    private final Progressable progressable;
    private final TimeValue rate;
    private final Log log;
    private final String id;

    HeartBeat(Progressable progressable, Configuration cfg, TimeValue delay, Log log) {
        String taskId;
        Assert.notNull(progressable, "a valid progressable is required to report status to Hadoop");
        TimeValue tv = HadoopCfgUtils.getTaskTimeout(cfg);
        Assert.isTrue(tv.getSeconds() > delay.getSeconds(), "Hadoop timeout is shorter than the heartbeat");
        this.progressable = progressable;
        this.rate = new TimeValue(tv.getMillis() - delay.getMillis(), TimeUnit.MILLISECONDS);
        this.log = log;
        TaskID taskID = HadoopCfgUtils.getTaskID(cfg);
        if (taskID == null) {
            log.warn((Object)"Cannot determine task id...");
            taskId = "<unknown>";
            if (log.isTraceEnabled()) {
                log.trace((Object)("Current configuration is " + HadoopCfgUtils.asProperties(cfg)));
            }
        } else {
            taskId = "" + taskID;
        }
        this.id = taskId;
    }

    void start() {
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        if (this.log != null && this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("Starting heartbeat for %s", this.id));
        }
        this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                if (HeartBeat.this.log != null && HeartBeat.this.log.isTraceEnabled()) {
                    HeartBeat.this.log.trace((Object)String.format("Heartbeat/progress sent to Hadoop for %s", HeartBeat.this.id));
                }
                HeartBeat.this.progressable.progress();
            }
        }, this.rate.getMillis(), TimeUnit.MILLISECONDS);
    }

    void stop() {
        if (this.log != null && this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("Stopping heartbeat for %s", this.id));
        }
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }
}

