/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.hive;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.elasticsearch.hadoop.cfg.HadoopSettingsManager;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.hive.HiveUtils;
import org.elasticsearch.hadoop.hive.HiveValueReader;
import org.elasticsearch.hadoop.mr.EsInputFormat;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.util.StringUtils;

public class EsHiveInputFormat
extends EsInputFormat<Text, Map<Writable, Writable>> {
    public FileSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        Settings settings = HadoopSettingsManager.loadFrom(job);
        Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
        InitializationUtils.setValueReaderIfNotSet(settings, HiveValueReader.class, log);
        settings.setProperty("es.internal.mr.target.fields", StringUtils.concatenateAndUriEncode(HiveUtils.columnToAlias(settings), ","));
        settings.setResourceRead(settings.getResourceRead());
        HiveUtils.init(settings, log);
        InputSplit[] shardSplits = super.getSplits(job, numSplits);
        FileSplit[] wrappers = new FileSplit[shardSplits.length];
        Path path = new Path(job.get("location"));
        for (int i = 0; i < wrappers.length; ++i) {
            wrappers[i] = new EsHiveSplit(shardSplits[i], path);
        }
        return wrappers;
    }

    @Override
    public EsInputFormat.WritableShardRecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) {
        return new EsInputFormat.WritableShardRecordReader(((EsHiveSplit)split).delegate, (Configuration)job, reporter);
    }

    static class EsHiveSplit
    extends FileSplit {
        InputSplit delegate;
        private Path path;

        EsHiveSplit() {
            this(new EsInputFormat.ShardInputSplit(), null);
        }

        EsHiveSplit(InputSplit delegate, Path path) {
            super(path, 0L, 0L, (String[])null);
            this.delegate = delegate;
            this.path = path;
        }

        public long getLength() {
            return 1L;
        }

        public String[] getLocations() throws IOException {
            return this.delegate.getLocations();
        }

        public void write(DataOutput out) throws IOException {
            Text.writeString((DataOutput)out, (String)this.path.toString());
            this.delegate.write(out);
        }

        public void readFields(DataInput in) throws IOException {
            this.path = new Path(Text.readString((DataInput)in));
            this.delegate.readFields(in);
        }

        public String toString() {
            return this.delegate.toString();
        }

        public Path getPath() {
            return this.path;
        }
    }
}

