/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.hive;

import java.sql.Timestamp;
import javax.xml.bind.DatatypeConverter;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.io.Writable;
import org.elasticsearch.hadoop.mr.WritableValueReader;

public class HiveValueReader
extends WritableValueReader {
    @Override
    protected Class<? extends Writable> dateType() {
        return TimestampWritable.class;
    }

    @Override
    protected Class<? extends Writable> doubleType() {
        return DoubleWritable.class;
    }

    @Override
    protected Class<? extends Writable> byteType() {
        return ByteWritable.class;
    }

    @Override
    protected Class<? extends Writable> shortType() {
        return ShortWritable.class;
    }

    @Override
    protected Object parseDate(Long value) {
        return new TimestampWritable(new Timestamp(value));
    }

    @Override
    protected Object parseDate(String value) {
        return new TimestampWritable(new Timestamp(DatatypeConverter.parseDateTime((String)value).getTimeInMillis()));
    }

    @Override
    protected Object processDouble(Double value) {
        return new DoubleWritable(value.doubleValue());
    }

    @Override
    protected Object processByte(Byte value) {
        return new ByteWritable(value.byteValue());
    }

    @Override
    protected Object processShort(Short value) {
        return new ShortWritable(value.shortValue());
    }
}

