/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import java.util.Properties;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.util.IOUtils;

public abstract class Version {
    private static final String UNKNOWN = "Unknown";
    private static final String VER;
    private static final String HASH;
    private static final String SHORT_HASH;
    public static boolean printed;

    public static String version() {
        return "v" + Version.versionNumber() + " [" + Version.versionHashShort() + "]";
    }

    public static String versionNumber() {
        return VER;
    }

    public static String versionHash() {
        return HASH;
    }

    public static String versionHashShort() {
        return SHORT_HASH;
    }

    public static void logVersion() {
        if (!printed) {
            printed = true;
            LogFactory.getLog(Version.class).info((Object)("Elasticsearch Hadoop " + Version.version()));
        }
    }

    static {
        printed = false;
        Properties build = new Properties();
        try {
            build = IOUtils.propsFromString(IOUtils.asString(Version.class.getResourceAsStream("/esh-build.properties")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        VER = build.getProperty("version", UNKNOWN);
        HASH = build.getProperty("hash", UNKNOWN);
        SHORT_HASH = HASH.length() > 10 ? HASH.substring(0, 10) : HASH;
    }
}

