/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.mr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.elasticsearch.hadoop.util.ReflectionUtils;

public class WritableArrayWritable
extends ArrayWritable {
    static final Field VALUE_CLASS_FIELD = ReflectionUtils.findField(ArrayWritable.class, "valueClass");

    public WritableArrayWritable(Class<? extends Writable> valueClass, Writable[] values) {
        super(valueClass, values);
    }

    public WritableArrayWritable(Class<? extends Writable> valueClass) {
        super(valueClass);
    }

    public WritableArrayWritable(String[] strings) {
        super(strings);
    }

    WritableArrayWritable() {
        super(NullWritable.class);
    }

    public void setValueClass(Class<Writable> valueClass) {
        ReflectionUtils.setField(VALUE_CLASS_FIELD, (Object)this, valueClass);
    }

    public void readFields(DataInput in) throws IOException {
        String valueClass = in.readUTF();
        try {
            ReflectionUtils.setField(VALUE_CLASS_FIELD, (Object)this, Class.forName(valueClass, false, ((Object)((Object)this)).getClass().getClassLoader()));
        }
        catch (ClassNotFoundException ex) {
            throw new IOException("Cannot load class " + valueClass, ex);
        }
        super.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.getValueClass().getName());
        super.write(out);
    }

    static {
        ReflectionUtils.makeAccessible(VALUE_CLASS_FIELD);
    }
}

