/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.hive;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.hive.HiveType;
import org.elasticsearch.hadoop.hive.HiveUtils;
import org.elasticsearch.hadoop.hive.HiveWritableValueWriter;
import org.elasticsearch.hadoop.serialization.Generator;
import org.elasticsearch.hadoop.serialization.SettingsAware;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;
import org.elasticsearch.hadoop.util.FieldAlias;

public class HiveValueWriter
implements SettingsAware,
ValueWriter<HiveType> {
    private final boolean writeUnknownTypes;
    private final ValueWriter<Writable> writableWriter = new HiveWritableValueWriter(false);
    private FieldAlias alias = new FieldAlias();

    public HiveValueWriter() {
        this.writeUnknownTypes = false;
    }

    @Override
    public boolean write(HiveType type, Generator generator) {
        boolean result = this.write(type.getObject(), type.getObjectInspector(), generator);
        return result;
    }

    private boolean write(Object data, ObjectInspector oi, Generator generator) {
        if (data == null) {
            generator.writeNull();
            return true;
        }
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                Writable writable = (Writable)((PrimitiveObjectInspector)oi).getPrimitiveWritableObject(data);
                if (this.writableWriter.write(writable, generator)) break;
                return false;
            }
            case LIST: {
                ListObjectInspector loi = (ListObjectInspector)oi;
                generator.writeBeginArray();
                for (int i = 0; i < loi.getListLength(data); ++i) {
                    if (this.write(loi.getListElement(data, i), loi.getListElementObjectInspector(), generator)) continue;
                    return false;
                }
                generator.writeEndArray();
                break;
            }
            case MAP: {
                MapObjectInspector moi = (MapObjectInspector)oi;
                generator.writeBeginObject();
                for (Map.Entry entry : moi.getMap(data).entrySet()) {
                    generator.writeFieldName(this.alias.toES(entry.getKey().toString()));
                    if (this.write(entry.getValue(), moi.getMapValueObjectInspector(), generator)) continue;
                    return false;
                }
                generator.writeEndObject();
                break;
            }
            case STRUCT: {
                StructObjectInspector soi = (StructObjectInspector)oi;
                List refs = soi.getAllStructFieldRefs();
                generator.writeBeginObject();
                for (StructField structField : refs) {
                    generator.writeFieldName(this.alias.toES(structField.getFieldName()));
                    if (this.write(soi.getStructFieldData(data, structField), structField.getFieldObjectInspector(), generator)) continue;
                    return false;
                }
                generator.writeEndObject();
                break;
            }
            case UNION: {
                throw new UnsupportedOperationException("union not yet supported");
            }
            default: {
                if (this.writeUnknownTypes) {
                    return this.handleUnknown(data, oi, generator);
                }
                return false;
            }
        }
        return true;
    }

    protected boolean handleUnknown(Object value, ObjectInspector oi, Generator generator) {
        return false;
    }

    @Override
    public void setSettings(Settings settings) {
        this.alias = HiveUtils.alias(settings);
    }
}

