/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.cfg;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.FieldPresenceValidation;
import org.elasticsearch.hadoop.cfg.InternalConfigurationOptions;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.unit.Booleans;
import org.elasticsearch.hadoop.util.unit.ByteSizeValue;
import org.elasticsearch.hadoop.util.unit.TimeValue;

public abstract class Settings
implements InternalConfigurationOptions {
    public String getNodes() {
        String host = this.getProperty("es.host");
        if (StringUtils.hasText(host)) {
            throw new EsHadoopIllegalArgumentException(String.format("`%s` property has been deprecated - use `%s` instead", "es.host", "es.nodes"));
        }
        return this.getProperty("es.nodes", "localhost");
    }

    public int getPort() {
        return Integer.valueOf(this.getProperty("es.port", "9200"));
    }

    public boolean getNodesDiscovery() {
        return Booleans.parseBoolean(this.getProperty("es.nodes.discovery", "true"));
    }

    public long getHttpTimeout() {
        return TimeValue.parseTimeValue(this.getProperty("es.http.timeout", "1m")).getMillis();
    }

    public int getHttpRetries() {
        return Integer.valueOf(this.getProperty("es.http.retries", "3"));
    }

    public int getBatchSizeInBytes() {
        return ByteSizeValue.parseBytesSizeValue(this.getProperty("es.batch.size.bytes", "1mb")).bytesAsInt();
    }

    public int getBatchSizeInEntries() {
        return Integer.valueOf(this.getProperty("es.batch.size.entries", "1000"));
    }

    public int getBatchWriteRetryCount() {
        return Integer.parseInt(this.getProperty("es.batch.write.retry.count", "3"));
    }

    public long getBatchWriteRetryWait() {
        return TimeValue.parseTimeValue(this.getProperty("es.batch.write.retry.wait", "10s")).getMillis();
    }

    public String getBatchWriteRetryPolicy() {
        return this.getProperty("es.batch.write.retry.policy", "simple");
    }

    public boolean getBatchRefreshAfterWrite() {
        return Booleans.parseBoolean(this.getProperty("es.batch.write.refresh", "true"));
    }

    public long getScrollKeepAlive() {
        return TimeValue.parseTimeValue(this.getProperty("es.scroll.keepalive", "5m")).getMillis();
    }

    public long getScrollSize() {
        return Long.valueOf(this.getProperty("es.scroll.size", "50"));
    }

    public String getScrollFields() {
        String internalFields = this.getProperty("es.internal.mr.target.fields");
        return StringUtils.hasText(internalFields) ? internalFields : this.getProperty("es.scroll.fields");
    }

    public String getSerializerValueWriterClassName() {
        return this.getProperty("es.ser.writer.value.class");
    }

    public String getSerializerBytesConverterClassName() {
        return this.getProperty("es.ser.writer.bytes.class");
    }

    public String getSerializerValueReaderClassName() {
        return this.getProperty("es.ser.reader.value.class");
    }

    public boolean getIndexAutoCreate() {
        return Booleans.parseBoolean(this.getProperty("es.index.auto.create", "yes"));
    }

    public boolean getIndexReadMissingAsEmpty() {
        return Booleans.parseBoolean(this.getProperty("es.index.read.missing.as.empty", "false"));
    }

    public boolean getInputAsJson() {
        return Booleans.parseBoolean(this.getProperty("es.input.json", "no"));
    }

    public String getOperation() {
        return this.getProperty("es.write.operation", "index").toLowerCase(Locale.ENGLISH);
    }

    public String getMappingId() {
        return this.getProperty("es.mapping.id");
    }

    public String getMappingParent() {
        return this.getProperty("es.mapping.parent");
    }

    public String getMappingVersion() {
        return this.getProperty("es.mapping.version");
    }

    public String getMappingRouting() {
        return this.getProperty("es.mapping.routing");
    }

    public String getMappingTtl() {
        return this.getProperty("es.mapping.ttl");
    }

    public String getMappingTimestamp() {
        return this.getProperty("es.mapping.timestamp");
    }

    public String getMappingDefaultClassExtractor() {
        return this.getProperty("es.mapping.default.extractor.class");
    }

    public String getMappingIdExtractorClassName() {
        return this.getProperty("es.mapping.id.extractor.class", this.getMappingDefaultClassExtractor());
    }

    public String getMappingParentExtractorClassName() {
        return this.getProperty("es.mapping.parent.extractor.class", this.getMappingDefaultClassExtractor());
    }

    public String getMappingVersionExtractorClassName() {
        return this.getProperty("es.mapping.version.extractor.class", this.getMappingDefaultClassExtractor());
    }

    public String getMappingRoutingExtractorClassName() {
        return this.getProperty("es.mapping.routing.extractor.class", this.getMappingDefaultClassExtractor());
    }

    public String getMappingTtlExtractorClassName() {
        return this.getProperty("es.mapping.ttl.extractor.class", this.getMappingDefaultClassExtractor());
    }

    public String getMappingTimestampExtractorClassName() {
        return this.getProperty("es.mapping.timestamp.extractor.class", this.getMappingDefaultClassExtractor());
    }

    public String getMappingIndexExtractorClassName() {
        return this.getProperty("es.mapping.index.extractor.class", ES_MAPPING_DEFAULT_INDEX_EXTRACTOR_CLASS);
    }

    public String getMappingIndexFormatterClassName() {
        return this.getProperty("es.mapping.index.formatter.class", ES_MAPPING_DEFAULT_INDEX_FORMATTER_CLASS);
    }

    public String getMappingParamsExtractorClassName() {
        return this.getProperty("es.mapping.params.extractor.class", ES_MAPPING_PARAMS_DEFAULT_EXTRACTOR_CLASS);
    }

    public int getUpdateRetryOnConflict() {
        return Integer.parseInt(this.getProperty("es.update.retry.on.conflict", "0"));
    }

    public String getUpdateScript() {
        return this.getProperty("es.update.script");
    }

    public String getUpdateScriptLang() {
        return this.getProperty("es.update.script.lang");
    }

    public String getUpdateScriptParams() {
        return this.getProperty("es.update.script.params");
    }

    public String getUpdateScriptParamsJson() {
        return this.getProperty("es.update.script.params.json");
    }

    public boolean hasUpdateScript() {
        String op = this.getOperation();
        return ("update".equals(op) || "upsert".equals(op)) && StringUtils.hasText(this.getUpdateScript());
    }

    public boolean hasUpdateScriptParams() {
        return this.hasUpdateScript() && StringUtils.hasText(this.getUpdateScriptParams());
    }

    public boolean hasUpdateScriptParamsJson() {
        return this.hasUpdateScript() && StringUtils.hasText(this.getUpdateScriptParamsJson());
    }

    public boolean getFieldReadEmptyAsNull() {
        return Booleans.parseBoolean(this.getProperty("es.field.read.empty.as.null", "yes"));
    }

    public FieldPresenceValidation getFieldExistanceValidation() {
        return FieldPresenceValidation.valueOf(this.getProperty("es.field.read.validate.presence", "warn").toUpperCase());
    }

    public TimeValue getHeartBeatLead() {
        return TimeValue.parseTimeValue(this.getProperty("es.action.heart.beat.lead", "15s"));
    }

    public String getNetworkProxyHttpHost() {
        return this.getProperty("es.net.proxy.http.host");
    }

    public int getNetworkProxyHttpPort() {
        return Integer.valueOf(this.getProperty("es.net.proxy.http.port", "-1"));
    }

    public String getNetworkProxyHttpUser() {
        return this.getProperty("es.net.proxy.http.user");
    }

    public String getNetworkProxyHttpPass() {
        return this.getProperty("es.net.proxy.http.pass");
    }

    public boolean getNetworkHttpUseSystemProperties() {
        return Booleans.parseBoolean(this.getProperty("es.net.proxy.http.use.system.props", "yes"));
    }

    public String getNetworkProxySocksHost() {
        return this.getProperty("es.net.proxy.socks.host");
    }

    public int getNetworkProxySocksPort() {
        return Integer.valueOf(this.getProperty("es.net.proxy.socks.port", "-1"));
    }

    public String getNetworkProxySocksUser() {
        return this.getProperty("es.net.proxy.socks.user");
    }

    public String getNetworkProxySocksPass() {
        return this.getProperty("es.net.proxy.socks.pass");
    }

    public boolean getNetworkSocksUseSystemProperties() {
        return Booleans.parseBoolean(this.getProperty("es.net.proxy.socks.use.system.props", "yes"));
    }

    public Settings setNodes(String hosts) {
        this.setProperty("es.nodes", hosts);
        return this;
    }

    @Deprecated
    public Settings setHosts(String hosts) {
        return this.setNodes(hosts);
    }

    public Settings setPort(int port) {
        this.setProperty("es.port", "" + port);
        return this;
    }

    public Settings setResourceRead(String index) {
        this.setProperty("es.resource.read", index);
        return this;
    }

    public Settings setResourceWrite(String index) {
        this.setProperty("es.resource.write", index);
        return this;
    }

    public Settings setQuery(String query) {
        this.setProperty("es.query", StringUtils.hasText(query) ? query : "");
        return this;
    }

    protected String getResource() {
        return this.getProperty("es.resource");
    }

    public String getResourceRead() {
        return this.getProperty("es.resource.read", this.getResource());
    }

    public String getResourceWrite() {
        return this.getProperty("es.resource.write", this.getResource());
    }

    public String getQuery() {
        return this.getProperty("es.query");
    }

    public abstract InputStream loadResource(String var1);

    public abstract Settings copy();

    protected String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        if (!StringUtils.hasText(value)) {
            return defaultValue;
        }
        return value;
    }

    public abstract String getProperty(String var1);

    public abstract void setProperty(String var1, String var2);

    public Settings merge(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return this;
        }
        Enumeration<?> propertyNames = properties.propertyNames();
        Object prop = null;
        while (propertyNames.hasMoreElements()) {
            prop = propertyNames.nextElement();
            if (!(prop instanceof String)) continue;
            Object value = properties.get(prop);
            this.setProperty(prop, value.toString());
        }
        return this;
    }

    public Settings load(String source) {
        Properties copy = IOUtils.propsFromString(source);
        this.merge(copy);
        return this;
    }

    public String save() {
        Properties copy = this.asProperties();
        return IOUtils.propsToString(copy);
    }

    protected abstract Properties asProperties();
}

