/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.util.StringUtils;

public abstract class SettingsUtils {
    private static List<String> qualifyHosts(String hosts, int defaultPort) {
        List<String> list = StringUtils.tokenize(hosts);
        for (int i = 0; i < list.size(); ++i) {
            String host = list.get(i);
            list.set(i, SettingsUtils.qualifyHost(host, defaultPort));
        }
        return list;
    }

    private static String qualifyHost(String host, int defaultPort) {
        return host.contains(":") ? host : host + ":" + defaultPort;
    }

    public static List<String> nodes(Settings settings) {
        String h = null;
        String discoveredHosts = settings.getProperty("es.internal.hosts");
        h = StringUtils.hasText(discoveredHosts) ? discoveredHosts : settings.getNodes();
        return SettingsUtils.qualifyHosts(h, settings.getPort());
    }

    public static Map<String, String> aliases(String definition) {
        List<String> aliases = StringUtils.tokenize(definition, ",");
        LinkedHashMap<String, String> aliasMap = new LinkedHashMap<String, String>();
        if (aliases != null) {
            for (String string : aliases) {
                int index = (string = string.trim()).indexOf(":");
                if (index <= 0) continue;
                String key = string.substring(0, index);
                aliasMap.put(key, string.substring(index + 1));
                aliasMap.put(key.toLowerCase(Locale.ENGLISH), string.substring(index + 1));
            }
        }
        return aliasMap;
    }

    public static boolean isEs10(Settings settings) {
        String version = settings.getProperty("es.internal.es.version");
        if (!StringUtils.hasText(version)) {
            return true;
        }
        return "1.0.0.RC".compareTo(version) <= 0 || "1.0.0".equals(version);
    }
}

