/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.ErrorUtils;
import org.elasticsearch.hadoop.rest.EsHadoopInvalidRequest;
import org.elasticsearch.hadoop.rest.EsHadoopParsingException;
import org.elasticsearch.hadoop.rest.HttpRetryPolicy;
import org.elasticsearch.hadoop.rest.HttpStatus;
import org.elasticsearch.hadoop.rest.NetworkClient;
import org.elasticsearch.hadoop.rest.NoHttpRetryPolicy;
import org.elasticsearch.hadoop.rest.Request;
import org.elasticsearch.hadoop.rest.Resource;
import org.elasticsearch.hadoop.rest.Response;
import org.elasticsearch.hadoop.rest.Retry;
import org.elasticsearch.hadoop.rest.SimpleHttpRetryPolicy;
import org.elasticsearch.hadoop.rest.SimpleRequest;
import org.elasticsearch.hadoop.rest.stats.Stats;
import org.elasticsearch.hadoop.rest.stats.StatsAware;
import org.elasticsearch.hadoop.serialization.ParsingUtils;
import org.elasticsearch.hadoop.serialization.dto.Node;
import org.elasticsearch.hadoop.serialization.json.JacksonJsonParser;
import org.elasticsearch.hadoop.serialization.json.JsonFactory;
import org.elasticsearch.hadoop.serialization.json.ObjectReader;
import org.elasticsearch.hadoop.util.ByteSequence;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.hadoop.util.SettingsUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.TrackingBytesArray;
import org.elasticsearch.hadoop.util.unit.TimeValue;

public class RestClient
implements Closeable,
StatsAware {
    private NetworkClient network;
    private final ObjectMapper mapper = new ObjectMapper();
    private TimeValue scrollKeepAlive;
    private boolean indexReadMissingAsEmpty;
    private final HttpRetryPolicy retryPolicy;
    private final Stats stats;

    public RestClient(Settings settings) {
        this.mapper.configure(DeserializationConfig.Feature.USE_ANNOTATIONS, false);
        this.mapper.configure(SerializationConfig.Feature.USE_ANNOTATIONS, false);
        this.stats = new Stats();
        this.network = new NetworkClient(settings, SettingsUtils.nodes(settings));
        this.scrollKeepAlive = TimeValue.timeValueMillis(settings.getScrollKeepAlive());
        this.indexReadMissingAsEmpty = settings.getIndexReadMissingAsEmpty();
        String retryPolicyName = settings.getBatchWriteRetryPolicy();
        if ("simple".equals(retryPolicyName)) {
            retryPolicyName = SimpleHttpRetryPolicy.class.getName();
        } else if ("none".equals(retryPolicyName)) {
            retryPolicyName = NoHttpRetryPolicy.class.getName();
        }
        this.retryPolicy = (HttpRetryPolicy)ObjectUtils.instantiate(retryPolicyName, settings);
    }

    public List<String> discoverNodes() {
        String endpoint = "_nodes/transport";
        Map nodes = (Map)this.get(endpoint, "nodes");
        ArrayList<String> hosts = new ArrayList<String>(nodes.size());
        for (Map value : nodes.values()) {
            String inet = (String)value.get("http_address");
            if (!StringUtils.hasText(inet)) continue;
            int startIp = inet.indexOf("/") + 1;
            int endIp = inet.indexOf("]");
            inet = inet.substring(startIp, endIp);
            hosts.add(inet);
        }
        return hosts;
    }

    private <T> T get(String q, String string) {
        return this.parseContent(this.execute(Request.Method.GET, q), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T parseContent(InputStream content, String string) {
        Map map = Collections.emptyMap();
        try {
            JsonParser jsonParser = this.mapper.getJsonFactory().createJsonParser(content);
            try {
                map = (Map)this.mapper.readValue(jsonParser, Map.class);
            }
            finally {
                this.countStreamStats(content);
            }
        }
        catch (IOException ex) {
            throw new EsHadoopParsingException(ex);
        }
        return (T)(string != null ? map.get(string) : map);
    }

    public void bulk(Resource resource, TrackingBytesArray data) {
        Retry retry = this.retryPolicy.init();
        int httpStatus = 0;
        boolean isRetry = false;
        do {
            long start = this.network.transportStats().netTotalTime;
            Response response = this.execute(Request.Method.PUT, resource.bulk(), data);
            long spent = this.network.transportStats().netTotalTime - start;
            ++this.stats.bulkTotal;
            this.stats.docsSent += (long)data.entries();
            this.stats.bulkTotalTime += spent;
            if (isRetry) {
                this.stats.docsRetried += (long)data.entries();
                this.stats.bytesRetried += (long)data.length();
                ++this.stats.bulkRetries;
                this.stats.bulkRetriesTotalTime += spent;
            }
            isRetry = true;
            int n = httpStatus = this.retryFailedEntries(response.body(), data) ? 503 : 200;
        } while (data.length() > 0 && retry.retry(httpStatus));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean retryFailedEntries(InputStream content, TrackingBytesArray data) {
        try {
            ObjectReader r = JsonFactory.objectReader(this.mapper, Map.class);
            JsonParser parser = this.mapper.getJsonFactory().createJsonParser(content);
            try {
                if (ParsingUtils.seek("items", new JacksonJsonParser(parser)) == null) {
                    this.stats.bytesAccepted += (long)data.length();
                    this.stats.docsAccepted += (long)data.entries();
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.countStreamStats(content);
            }
            int entryToDeletePosition = 0;
            Iterator iterator = r.readValues(parser);
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                Map values = (Map)map.values().iterator().next();
                String error = (String)values.get("error");
                if (error != null) {
                    Integer status = (Integer)values.get("status");
                    if (status != null && HttpStatus.canRetry(status) || error.contains("EsRejectedExecutionException")) {
                        ++entryToDeletePosition;
                        continue;
                    }
                    String message = status != null ? String.format("[%s(%s) - %s]", HttpStatus.getText(status), status, this.prettify(error)) : this.prettify(error);
                    throw new EsHadoopInvalidRequest(String.format("Found unrecoverable error %s; Bailing out..", message));
                }
                this.stats.bytesAccepted += (long)data.length(entryToDeletePosition);
                ++this.stats.docsAccepted;
                data.remove(entryToDeletePosition);
            }
            if (entryToDeletePosition <= 0) return false;
            return true;
        }
        catch (IOException ex) {
            throw new EsHadoopParsingException(ex);
        }
    }

    private String prettify(String error) {
        String invalidFragment = ErrorUtils.extractInvalidXContent(error);
        String header = invalidFragment != null ? "Invalid JSON fragment received[" + invalidFragment + "]" : "";
        return header + "[" + error + "]";
    }

    private String prettify(String error, ByteSequence body) {
        String message = ErrorUtils.extractJsonParse(error, body);
        return message != null ? error + "; fragment[" + message + "]" : error;
    }

    public void refresh(Resource resource) {
        this.execute(Request.Method.POST, resource.refresh());
    }

    public void deleteIndex(String index) {
        this.execute(Request.Method.DELETE, index);
    }

    public List<List<Map<String, Object>>> targetShards(String index) {
        Response res;
        List shardsJson = null;
        String target = index + "/_search_shards";
        shardsJson = this.indexReadMissingAsEmpty ? ((res = this.execute(Request.Method.GET, target, false)).status() == 404 ? Collections.emptyList() : (List)this.parseContent(res.body(), "shards")) : (List)this.get(target, "shards");
        return shardsJson;
    }

    public Map<String, Node> getNodes() {
        Map nodesData = (Map)this.get("_nodes/http", "nodes");
        LinkedHashMap<String, Node> nodes = new LinkedHashMap<String, Node>();
        for (Map.Entry entry : nodesData.entrySet()) {
            Node node = new Node((String)entry.getKey(), (Map)entry.getValue());
            if (!node.hasHttp()) continue;
            nodes.put((String)entry.getKey(), node);
        }
        return nodes;
    }

    public Map<String, Object> getMapping(String query) {
        return (Map)this.get(query, null);
    }

    @Override
    public void close() {
        if (this.network != null) {
            this.network.close();
            this.stats.aggregate(this.network.stats());
            this.network = null;
        }
    }

    protected InputStream execute(Request request) {
        return this.execute(request, true).body();
    }

    protected InputStream execute(Request.Method method, String path) {
        return this.execute(new SimpleRequest(method, null, path));
    }

    protected Response execute(Request.Method method, String path, boolean checkStatus) {
        return this.execute(new SimpleRequest(method, null, path), checkStatus);
    }

    protected Response execute(Request.Method method, String path, ByteSequence buffer) {
        return this.execute(new SimpleRequest(method, null, path, null, buffer), true);
    }

    protected Response execute(Request request, boolean checkStatus) {
        Response response = this.network.execute(request);
        if (checkStatus && response.hasFailed()) {
            String msg = null;
            try {
                msg = (String)this.parseContent(response.body(), "error");
                msg = this.prettify(msg, request.body());
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (!StringUtils.hasText(msg)) {
                msg = String.format("[%s] on [%s] failed; server[%s] returned [%s|%s:%s]", request.method().name(), request.path(), response.uri(), response.status(), response.statusDescription(), IOUtils.asStringAlways(response.body()));
            }
            throw new EsHadoopInvalidRequest(msg);
        }
        return response;
    }

    public String[] scan(String query, BytesArray body) {
        Map scan = (Map)this.parseContent(this.execute(Request.Method.POST, query, body).body(), null);
        String[] data = new String[]{scan.get("_scroll_id").toString(), ((Map)scan.get("hits")).get("total").toString()};
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream scroll(String scrollId) {
        long start = this.network.transportStats().netTotalTime;
        try {
            InputStream is = this.execute(Request.Method.POST, "_search/scroll?scroll=" + this.scrollKeepAlive.toString(), new BytesArray(scrollId.getBytes(StringUtils.UTF_8))).body();
            ++this.stats.scrollTotal;
            InputStream inputStream = is;
            return inputStream;
        }
        finally {
            this.stats.scrollTotalTime += this.network.transportStats().netTotalTime - start;
        }
    }

    public boolean exists(String indexOrType) {
        return this.execute(Request.Method.HEAD, indexOrType, false).hasSucceeded();
    }

    public boolean touch(String indexOrType) {
        return this.execute(Request.Method.PUT, indexOrType, false).hasSucceeded();
    }

    public void putMapping(String index, String mapping, byte[] bytes) {
        this.touch(index);
        this.execute(Request.Method.PUT, mapping, new BytesArray(bytes));
    }

    public String esVersion() {
        Map version = (Map)this.get("", "version");
        return (String)version.get("number");
    }

    public Map<String, Object> aliases(String index) {
        return (Map)this.get(index, null);
    }

    public boolean health(String index, HEALTH health, TimeValue timeout) {
        StringBuilder sb = new StringBuilder("/_cluster/health/");
        sb.append(index);
        sb.append("?wait_for_status=");
        sb.append(health.name().toLowerCase(Locale.ENGLISH));
        sb.append("&timeout=");
        sb.append(timeout.toString());
        return Boolean.TRUE.equals(this.get(sb.toString(), "timed_out"));
    }

    @Override
    public Stats stats() {
        Stats copy = new Stats(this.stats);
        if (this.network != null) {
            copy.aggregate(this.network.stats());
        }
        return copy;
    }

    private void countStreamStats(InputStream content) {
        if (content instanceof StatsAware) {
            this.stats.aggregate(((StatsAware)((Object)content)).stats());
        }
    }

    public static enum HEALTH {
        RED,
        YELLOW,
        GREEN;

    }
}

