/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.bulk;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.Resource;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;
import org.elasticsearch.hadoop.serialization.bulk.BulkCommand;
import org.elasticsearch.hadoop.serialization.bulk.BulkFactory;
import org.elasticsearch.hadoop.serialization.bulk.JsonScriptTemplateBulk;
import org.elasticsearch.hadoop.serialization.bulk.JsonTemplatedBulk;
import org.elasticsearch.hadoop.serialization.bulk.ScriptTemplateBulk;
import org.elasticsearch.hadoop.serialization.bulk.TemplatedBulk;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;
import org.elasticsearch.hadoop.serialization.field.IndexExtractor;
import org.elasticsearch.hadoop.serialization.field.JsonFieldExtractors;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.hadoop.util.StringUtils;

abstract class AbstractBulkFactory
implements BulkFactory {
    private static Log log = LogFactory.getLog(AbstractBulkFactory.class);
    private boolean jsonInput;
    private JsonFieldExtractors jsonExtractors;
    protected Settings settings;
    private ValueWriter<?> valueWriter;
    private IndexExtractor indexExtractor;
    private FieldExtractor idExtractor;
    private FieldExtractor parentExtractor;
    private FieldExtractor routingExtractor;
    private FieldExtractor versionExtractor;
    private FieldExtractor ttlExtractor;
    private FieldExtractor timestampExtractor;
    private FieldExtractor paramsExtractor;

    AbstractBulkFactory(Settings settings) {
        this.settings = settings;
        this.valueWriter = (ValueWriter)ObjectUtils.instantiate(settings.getSerializerValueWriterClassName(), settings);
        this.initFieldExtractors(settings);
    }

    private void initFieldExtractors(Settings settings) {
        this.jsonInput = settings.getInputAsJson();
        if (this.jsonInput) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"JSON input; using internal field extractor for efficient parsing...");
            }
            this.jsonExtractors = new JsonFieldExtractors(settings);
            this.indexExtractor = this.jsonExtractors.indexAndType();
            this.idExtractor = this.jsonExtractors.id();
            this.parentExtractor = this.jsonExtractors.parent();
            this.routingExtractor = this.jsonExtractors.routing();
            this.versionExtractor = this.jsonExtractors.version();
            this.ttlExtractor = this.jsonExtractors.ttl();
            this.timestampExtractor = this.jsonExtractors.timestamp();
            this.paramsExtractor = this.jsonExtractors.params();
        } else {
            if (settings.getMappingId() != null) {
                settings.setProperty("org.elasticsearch.hadoop.serialization.ConstantFieldExtractor.property", settings.getMappingId());
                this.idExtractor = (FieldExtractor)ObjectUtils.instantiate(settings.getMappingIdExtractorClassName(), settings);
            }
            if (settings.getMappingParent() != null) {
                settings.setProperty("org.elasticsearch.hadoop.serialization.ConstantFieldExtractor.property", settings.getMappingParent());
                this.parentExtractor = (FieldExtractor)ObjectUtils.instantiate(settings.getMappingParentExtractorClassName(), settings);
            }
            if (settings.getMappingRouting() != null) {
                settings.setProperty("org.elasticsearch.hadoop.serialization.ConstantFieldExtractor.property", settings.getMappingRouting());
                this.routingExtractor = (FieldExtractor)ObjectUtils.instantiate(settings.getMappingRoutingExtractorClassName(), settings);
            }
            if (settings.getMappingTtl() != null) {
                settings.setProperty("org.elasticsearch.hadoop.serialization.ConstantFieldExtractor.property", settings.getMappingTtl());
                this.ttlExtractor = (FieldExtractor)ObjectUtils.instantiate(settings.getMappingTtlExtractorClassName(), settings);
            }
            if (settings.getMappingVersion() != null) {
                settings.setProperty("org.elasticsearch.hadoop.serialization.ConstantFieldExtractor.property", settings.getMappingVersion());
                this.versionExtractor = (FieldExtractor)ObjectUtils.instantiate(settings.getMappingVersionExtractorClassName(), settings);
            }
            if (settings.getMappingTimestamp() != null) {
                settings.setProperty("org.elasticsearch.hadoop.serialization.ConstantFieldExtractor.property", settings.getMappingTimestamp());
                this.timestampExtractor = (FieldExtractor)ObjectUtils.instantiate(settings.getMappingTimestampExtractorClassName(), settings);
            }
            IndexExtractor iformat = (IndexExtractor)ObjectUtils.instantiate(settings.getMappingIndexExtractorClassName(), settings);
            iformat.compile(new Resource(settings, false).toString());
            if (iformat.hasPattern()) {
                this.indexExtractor = iformat;
            }
            if (settings.hasUpdateScriptParams()) {
                settings.setProperty("org.elasticsearch.hadoop.serialization.ConstantFieldExtractor.property", settings.getUpdateScriptParams());
                this.paramsExtractor = (FieldExtractor)ObjectUtils.instantiate(settings.getMappingParamsExtractorClassName(), settings);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Instantiated value writer [%s]", this.valueWriter));
                if (this.idExtractor != null) {
                    log.trace((Object)String.format("Instantiated id extractor [%s]", this.idExtractor));
                }
                if (this.parentExtractor != null) {
                    log.trace((Object)String.format("Instantiated parent extractor [%s]", this.parentExtractor));
                }
                if (this.routingExtractor != null) {
                    log.trace((Object)String.format("Instantiated routing extractor [%s]", this.routingExtractor));
                }
                if (this.ttlExtractor != null) {
                    log.trace((Object)String.format("Instantiated ttl extractor [%s]", this.ttlExtractor));
                }
                if (this.versionExtractor != null) {
                    log.trace((Object)String.format("Instantiated version extractor [%s]", this.versionExtractor));
                }
                if (this.timestampExtractor != null) {
                    log.trace((Object)String.format("Instantiated timestamp extractor [%s]", this.timestampExtractor));
                }
                if (this.paramsExtractor != null) {
                    log.trace((Object)String.format("Instantiated params extractor [%s]", this.paramsExtractor));
                }
            }
        }
    }

    protected IndexExtractor index() {
        return this.indexExtractor;
    }

    protected FieldExtractor id() {
        return this.idExtractor;
    }

    protected FieldExtractor parent() {
        return this.parentExtractor;
    }

    protected FieldExtractor routing() {
        return this.routingExtractor;
    }

    protected FieldExtractor ttl() {
        return this.ttlExtractor;
    }

    protected FieldExtractor version() {
        return this.versionExtractor;
    }

    protected FieldExtractor timestamp() {
        return this.timestampExtractor;
    }

    protected FieldExtractor params() {
        return this.paramsExtractor;
    }

    @Override
    public BulkCommand createBulk() {
        List<Object> before = new ArrayList<Object>();
        this.writeBeforeObject(before);
        List<Object> after = new ArrayList<Object>();
        this.writeAfterObject(after);
        before = this.compact(before);
        after = this.compact(after);
        boolean isScriptUpdate = this.settings.hasUpdateScript();
        if (this.jsonInput) {
            if (isScriptUpdate) {
                return new JsonScriptTemplateBulk(before, after, this.jsonExtractors, this.settings);
            }
            return new JsonTemplatedBulk(before, after, this.jsonExtractors, this.settings);
        }
        if (isScriptUpdate) {
            return new ScriptTemplateBulk(this.settings, before, after, this.valueWriter);
        }
        return new TemplatedBulk(before, after, this.valueWriter);
    }

    protected void writeAfterObject(List<Object> after) {
        after.add("\n");
    }

    private List<Object> compact(List<Object> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<Object> compacted = new ArrayList<Object>();
        StringBuilder accumulator = new StringBuilder();
        String lastString = null;
        for (Object object : list) {
            if (object instanceof FieldExtractor) {
                if (accumulator.length() > 0) {
                    compacted.add(accumulator.toString().getBytes(StringUtils.UTF_8));
                    accumulator.setLength(0);
                    lastString = null;
                }
                compacted.add(new TemplatedBulk.FieldWriter((FieldExtractor)object));
                continue;
            }
            String str = object.toString();
            if ("\"".equals(lastString) && str.startsWith("\"")) {
                accumulator.append(",");
            }
            lastString = str;
            accumulator.append(str);
        }
        if (accumulator.length() > 0) {
            compacted.add(accumulator.toString().getBytes(StringUtils.UTF_8));
        }
        return compacted;
    }

    protected void writeBeforeObject(List<Object> pieces) {
        this.startHeader(pieces);
        this.index(pieces);
        this.id(pieces);
        this.parent(pieces);
        this.routing(pieces);
        this.ttl(pieces);
        this.version(pieces);
        this.timestamp(pieces);
        this.otherHeader(pieces);
        this.endHeader(pieces);
        this.scriptParams(pieces);
    }

    private void startHeader(List<Object> pieces) {
        pieces.add("{\"" + this.getOperation() + "\":{");
    }

    private void endHeader(List<Object> pieces) {
        pieces.add("}}\n");
    }

    protected boolean index(List<Object> pieces) {
        if (this.index() != null) {
            pieces.add(this.index());
            return true;
        }
        return false;
    }

    protected boolean id(List<Object> pieces) {
        if (this.id() != null) {
            pieces.add("\"_id\":\"");
            pieces.add(this.id());
            pieces.add("\"");
            return true;
        }
        return false;
    }

    protected abstract String getOperation();

    protected boolean parent(List<Object> pieces) {
        if (this.parent() != null) {
            pieces.add("\"_parent\":\"");
            pieces.add(this.parent());
            pieces.add("\"");
            return true;
        }
        return false;
    }

    protected boolean routing(List<Object> pieces) {
        if (this.routing() != null) {
            pieces.add("\"_routing\":\"");
            pieces.add(this.routing());
            pieces.add("\"");
            return true;
        }
        return false;
    }

    protected boolean ttl(List<Object> pieces) {
        if (this.ttl() != null) {
            pieces.add("\"_ttl\":\"");
            pieces.add(this.ttl());
            pieces.add("\"");
            return true;
        }
        return false;
    }

    protected boolean version(List<Object> pieces) {
        if (this.version() != null) {
            pieces.add("\"_version\":\"");
            pieces.add(this.version());
            pieces.add("\"");
            return true;
        }
        return false;
    }

    protected boolean timestamp(List<Object> pieces) {
        if (this.timestamp() != null) {
            pieces.add("\"_timestamp\":\"");
            pieces.add(this.timestamp());
            pieces.add("\"");
            return true;
        }
        return false;
    }

    protected void otherHeader(List<Object> pieces) {
    }

    private boolean scriptParams(List<Object> pieces) {
        if (this.settings.hasUpdateScriptParamsJson()) {
            pieces.add("{\"params\":");
            pieces.add(this.settings.getUpdateScriptParamsJson().trim());
            pieces.add(",");
            return true;
        }
        if (this.params() != null) {
            pieces.add("{\"params\":{");
            pieces.add(this.params());
            pieces.add("},");
            return true;
        }
        return false;
    }
}

