/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import org.elasticsearch.hadoop.util.Assert;

public abstract class ObjectUtils {
    public static <T> T instantiate(String className, ClassLoader loader) {
        Assert.hasText(className, "No class name given");
        ClassLoader cl = loader != null ? loader : ObjectUtils.class.getClassLoader();
        Class<?> clz = null;
        try {
            clz = cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(String.format("Cannot load class [%s]", className), e);
        }
        try {
            return (T)clz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Cannot instantiate class [%s]", className), e);
        }
    }
}

