/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import java.io.IOException;
import java.io.OutputStream;
import org.elasticsearch.hadoop.util.ArrayUtils;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;

public class FastByteArrayOutputStream
extends OutputStream {
    private BytesArray data;

    public FastByteArrayOutputStream() {
        this(1024);
    }

    public FastByteArrayOutputStream(int size) {
        Assert.isTrue(size >= 0, "Negative initial size: " + size);
        this.data = new BytesArray(size);
    }

    public FastByteArrayOutputStream(BytesArray data) {
        this.data = data;
    }

    @Override
    public void write(int b) {
        int newcount = this.data.size + 1;
        if (newcount > this.data.bytes.length) {
            this.data.bytes = ArrayUtils.grow(this.data.bytes, newcount);
        }
        this.data.bytes[this.data.size] = (byte)b;
        this.data.size = newcount;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (len == 0) {
            return;
        }
        int newcount = this.data.size + len;
        if (newcount > this.data.bytes.length) {
            this.data.bytes = ArrayUtils.grow(this.data.bytes, newcount);
        }
        System.arraycopy(b, off, this.data.bytes, this.data.size, len);
        this.data.size = newcount;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.data.bytes, 0, this.data.size);
    }

    public BytesArray bytes() {
        return this.data;
    }

    public void setBytes(byte[] data, int size) {
        this.data.setBytes(data, size);
    }

    public int size() {
        return this.data.size();
    }

    public void reset() {
        this.data.reset();
    }

    public String toString() {
        return this.data.toString();
    }

    @Override
    public void close() throws IOException {
    }
}

