/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.json;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang.SerializationException;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.elasticsearch.hadoop.serialization.Generator;
import org.elasticsearch.hadoop.util.StringUtils;

public class JacksonJsonGenerator
implements Generator {
    private static final boolean JACKSON_16;
    private static final JsonFactory JSON_FACTORY;
    private final JsonGenerator generator;
    private final OutputStream out;

    public JacksonJsonGenerator(OutputStream out) {
        try {
            this.out = out;
            this.generator = JSON_FACTORY.createJsonGenerator(out, JsonEncoding.UTF8);
        }
        catch (IOException ex) {
            throw new SerializationException((Throwable)ex);
        }
    }

    public void usePrettyPrint() {
        this.generator.useDefaultPrettyPrinter();
    }

    @Override
    public void writeBeginArray() {
        try {
            this.generator.writeStartArray();
        }
        catch (IOException ex) {
            throw new SerializationException((Throwable)ex);
        }
    }

    @Override
    public void writeEndArray() {
        try {
            this.generator.writeEndArray();
        }
        catch (IOException ex) {
            throw new SerializationException((Throwable)ex);
        }
    }

    @Override
    public void writeBeginObject() {
        try {
            this.generator.writeStartObject();
        }
        catch (IOException ex) {
            throw new SerializationException((Throwable)ex);
        }
    }

    @Override
    public void writeEndObject() {
        try {
            this.generator.writeEndObject();
        }
        catch (IOException ex) {
            throw new SerializationException((Throwable)ex);
        }
    }

    @Override
    public void writeFieldName(String name) {
        try {
            this.generator.writeFieldName(name);
        }
        catch (IOException ex) {
            throw new SerializationException((Throwable)ex);
        }
    }

    @Override
    public void writeString(String text) {
        try {
            this.generator.writeString(text);
        }
        catch (IOException ex) {
            throw new SerializationException((Throwable)ex);
        }
    }

    @Override
    public void writeUTF8String(byte[] text, int offset, int len) {
        try {
            if (JACKSON_16) {
                this.generator.writeUTF8String(text, offset, len);
            } else {
                this.generator.writeString(new String(text, offset, len, StringUtils.UTF_8));
            }
        }
        catch (IOException ex) {
            throw new SerializationException((Throwable)ex);
        }
    }

    @Override
    public void writeUTF8String(byte[] text) {
        this.writeUTF8String(text, 0, text.length);
    }

    @Override
    public void writeBinary(byte[] data, int offset, int len) {
        try {
            this.generator.writeBinary(data, offset, len);
        }
        catch (IOException ex) {
            throw new SerializationException((Throwable)ex);
        }
    }

    @Override
    public void writeBinary(byte[] data) {
        this.writeBinary(data, 0, data.length);
    }

    @Override
    public void writeNumber(short s) {
        this.writeNumber((int)s);
    }

    @Override
    public void writeNumber(byte b) {
        this.writeNumber((int)b);
    }

    @Override
    public void writeNumber(int i) {
        try {
            this.generator.writeNumber(i);
        }
        catch (IOException ex) {
            throw new SerializationException((Throwable)ex);
        }
    }

    @Override
    public void writeNumber(long l) {
        try {
            this.generator.writeNumber(l);
        }
        catch (IOException ex) {
            throw new SerializationException((Throwable)ex);
        }
    }

    @Override
    public void writeNumber(double d) {
        try {
            this.generator.writeNumber(d);
        }
        catch (IOException ex) {
            throw new SerializationException((Throwable)ex);
        }
    }

    @Override
    public void writeNumber(float f) {
        try {
            this.generator.writeNumber(f);
        }
        catch (IOException ex) {
            throw new SerializationException((Throwable)ex);
        }
    }

    @Override
    public void writeBoolean(boolean b) {
        try {
            this.generator.writeBoolean(b);
        }
        catch (IOException ex) {
            throw new SerializationException((Throwable)ex);
        }
    }

    @Override
    public void writeNull() {
        try {
            this.generator.writeNull();
        }
        catch (IOException ex) {
            throw new SerializationException((Throwable)ex);
        }
    }

    @Override
    public void flush() {
        try {
            this.generator.flush();
        }
        catch (IOException ex) {
            throw new SerializationException((Throwable)ex);
        }
    }

    @Override
    public void close() {
        try {
            this.generator.close();
        }
        catch (IOException ex) {
            throw new SerializationException((Throwable)ex);
        }
    }

    @Override
    public Object getOutputTarget() {
        return this.out;
    }

    static {
        Class<?> versionClass = null;
        try {
            versionClass = Class.forName("org.codehaus.jackson.Version", false, JacksonJsonGenerator.class.getClassLoader());
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = JACKSON_16 = versionClass != null;
        if (!JACKSON_16) {
            LogFactory.getLog(JacksonJsonGenerator.class).warn((Object)"Old Jackson version (pre-1.7) detected; consider upgrading to improve performance");
        }
        JSON_FACTORY = new JsonFactory();
        JSON_FACTORY.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, true);
    }
}

