/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.SettingsAware;
import org.elasticsearch.hadoop.serialization.ValueReader;
import org.elasticsearch.hadoop.serialization.ValueWriter;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.hadoop.util.StringUtils;

public abstract class SerializationUtils {
    public static boolean setValueWriterIfNotSet(Settings settings, Class<? extends ValueWriter<?>> clazz, Log log) {
        if (!StringUtils.hasText(settings.getSerializerValueWriterClassName())) {
            settings.setProperty("es.ser.writer.class", clazz.getName());
            Log logger = log != null ? log : LogFactory.getLog(clazz);
            logger.debug((Object)String.format("Using pre-defined writer serializer [%s] as default", settings.getSerializerValueWriterClassName()));
            return true;
        }
        return false;
    }

    public static boolean setValueReaderIfNotSet(Settings settings, Class<? extends ValueReader> clazz, Log log) {
        if (!StringUtils.hasText(settings.getSerializerValueReaderClassName())) {
            settings.setProperty("es.ser.reader.class", clazz.getName());
            Log logger = log != null ? log : LogFactory.getLog(clazz);
            logger.debug((Object)String.format("Using pre-defined reader serializer [%s] as default", settings.getSerializerValueReaderClassName()));
            return true;
        }
        return false;
    }

    public static ValueReader instantiateValueReader(Settings settings) {
        String valueReader = settings.getSerializerValueReaderClassName();
        ValueReader reader = (ValueReader)ObjectUtils.instantiate(valueReader, null);
        if (reader instanceof SettingsAware) {
            ((SettingsAware)((Object)reader)).setSettings(settings);
        }
        return reader;
    }

    public static ValueWriter instantiateValueWriter(Settings settings) {
        String valueWriter = settings.getSerializerValueWriterClassName();
        ValueWriter writer = (ValueWriter)ObjectUtils.instantiate(valueWriter, null);
        if (writer instanceof SettingsAware) {
            ((SettingsAware)((Object)writer)).setSettings(settings);
        }
        return writer;
    }
}

