/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.dto;

import java.util.Map;

public class Shard {
    private State state;
    private boolean primary;
    private String node;
    private String relocatingNode;
    private Integer name;
    private String index;

    public Shard(Map<String, Object> data) {
        this.state = State.valueOf((String)data.get("state"));
        this.name = (Integer)data.get("shard");
        this.index = (String)data.get("index");
        this.relocatingNode = (String)data.get("relocating_node");
        this.node = (String)data.get("node");
        this.primary = Boolean.TRUE.equals(data.get("primary"));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Shard other = (Shard)obj;
        if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.node == null ? other.node != null : !this.node.equals(other.node));
    }

    public State getState() {
        return this.state;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public String getNode() {
        return this.node;
    }

    public String getRelocatingNode() {
        return this.relocatingNode;
    }

    public Integer getName() {
        return this.name;
    }

    public String getIndex() {
        return this.index;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Shard[state=").append((Object)this.state).append(", primary=").append(this.primary).append(", node=").append(this.node).append(", name=").append(this.name).append(", index=").append(this.index).append("]");
        return builder.toString();
    }

    public static enum State {
        UNASSIGNED,
        INITIALIZING,
        STARTED,
        RELOCATING;


        public boolean isStarted() {
            return STARTED == this;
        }
    }
}

