/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

public class Resource {
    private final StringBuilder resource;
    private final String root;
    private final String type;
    private final String index;

    public Resource(String resource) {
        String localRoot;
        this.resource = new StringBuilder(resource);
        int location = resource.lastIndexOf("_");
        if (location <= 0) {
            location = resource.length();
        }
        if (!(localRoot = resource.substring(0, location)).endsWith("/")) {
            localRoot = localRoot + "/";
        }
        this.root = localRoot;
        location = localRoot.substring(0, this.root.length() - 1).lastIndexOf("/");
        this.type = this.root.substring(location + 1, this.root.length() - 1);
        this.index = this.root.substring(0, location);
    }

    String bulkIndexing() {
        return this.root + "_bulk";
    }

    String targetShards() {
        return this.root + "_search_shards";
    }

    String mapping() {
        return this.root + "_mapping";
    }

    String indexAndType() {
        return this.root;
    }

    public String type() {
        return this.type;
    }

    public String index() {
        return this.index;
    }
}

