/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.io.IOException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.BufferedRestClient;
import org.elasticsearch.hadoop.rest.ScrollQuery;
import org.elasticsearch.hadoop.serialization.ScrollReader;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.unit.TimeValue;

public class QueryBuilder {
    private final String query;
    private TimeValue time = TimeValue.timeValueMinutes(10L);
    private long size = 50L;
    private String shard;
    private String node;

    private QueryBuilder(String query) {
        Assert.hasText(query, "Invalid query");
        this.query = query;
    }

    public static QueryBuilder query(Settings settings) {
        return new QueryBuilder(settings.getTargetResource()).time(settings.getScrollKeepAlive()).size(settings.getScrollSize());
    }

    public static QueryBuilder query(String query) {
        return new QueryBuilder(query);
    }

    public QueryBuilder size(long size) {
        this.size = size;
        return this;
    }

    public QueryBuilder time(long timeInMillis) {
        Assert.isTrue(timeInMillis > 0L, "Invalid time");
        this.time = TimeValue.timeValueMillis(timeInMillis);
        return this;
    }

    public QueryBuilder onlyNode(String node) {
        Assert.hasText(node, "Invalid node");
        this.node = node;
        return this;
    }

    public QueryBuilder shard(String shard) {
        Assert.hasText(shard, "Invalid shard");
        this.shard = shard;
        return this;
    }

    private String assemble() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.query);
        sb.append("&search_type=scan&scroll=");
        sb.append(this.time.minutes());
        sb.append("m&size=");
        sb.append(this.size);
        StringBuilder pref = new StringBuilder();
        if (StringUtils.hasText(this.shard)) {
            pref.append("_shards:");
            pref.append(this.shard);
        }
        if (StringUtils.hasText(this.node)) {
            if (pref.length() > 0) {
                pref.append(";");
            }
            pref.append("_only_node:");
            pref.append(this.node);
        }
        if (pref.length() > 0) {
            sb.append("&preference=");
            sb.append(pref.toString());
        }
        return sb.toString();
    }

    public ScrollQuery build(BufferedRestClient client, ScrollReader reader) {
        String scrollUri = this.assemble();
        try {
            return client.scan(scrollUri, reader);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot build scroll [" + scrollUri + "]", ex);
        }
    }

    public String toString() {
        return "QueryBuilder [" + this.assemble() + "]";
    }
}

